/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.notifier.IMassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PinnedMassSpectrumUIWithLabel
extends Composite
implements IMassSpectrumSelectionUpdateNotifier {
    private SimpleMassSpectrumUI massSpectrumUI;
    private Button pinButton;
    private Label infoLabel;
    private IScanMSD massSpectrum;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0####");
    private MassValueDisplayPrecision massValueDisplayPrecision;
    private boolean isPinned = false;

    public PinnedMassSpectrumUIWithLabel(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite labelbar = new Composite(composite, 4);
        labelbar.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        labelbar.setLayoutData((Object)gridData);
        this.pinButton = new Button(labelbar, 8);
        this.setPinButtonText();
        this.pinButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PinnedMassSpectrumUIWithLabel.this.isPinned = !PinnedMassSpectrumUIWithLabel.this.isPinned;
                PinnedMassSpectrumUIWithLabel.this.setPinButtonText();
            }
        });
        this.infoLabel = new Label(labelbar, 0);
        this.infoLabel.setText("");
        this.infoLabel.setLayoutData((Object)new GridData(768));
        this.massSpectrumUI = new SimpleMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.massSpectrumUI.setLayoutData(gridData);
    }

    public void update(IScanMSD massSpectrum, boolean forceReload) {
        if (massSpectrum != null && !this.isPinned && this.massSpectrum != massSpectrum) {
            this.massSpectrum = massSpectrum;
            this.setMassSpectrumLabel(massSpectrum);
            this.massSpectrumUI.update(this.massSpectrum, forceReload);
        }
    }

    private void setPinButtonText() {
        this.pinButton.setText("");
        if (this.isPinned) {
            this.pinButton.setImage(ApplicationImageFactory.getInstance().getImage("unpinMassSpectrum.gif", "16x16"));
        } else {
            this.pinButton.setImage(ApplicationImageFactory.getInstance().getImage("pinMassSpectrum.gif", "16x16"));
        }
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum) {
        StringBuilder builder = new StringBuilder();
        if (massSpectrum instanceof IVendorMassSpectrum) {
            IVendorMassSpectrum actualMassSpectrum = (IVendorMassSpectrum)massSpectrum;
            builder.append("Scan: ");
            builder.append(actualMassSpectrum.getScanNumber());
            builder.append(" | ");
            builder.append("RT: ");
            builder.append(this.decimalFormat.format((double)actualMassSpectrum.getRetentionTime() / 60000.0));
            builder.append(" | ");
            builder.append("RI: ");
            if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                builder.append(Integer.toString((int)actualMassSpectrum.getRetentionIndex()));
            } else {
                builder.append(this.decimalFormat.format(actualMassSpectrum.getRetentionIndex()));
            }
            builder.append(" | ");
            builder.append("Detector: MS");
            builder.append(actualMassSpectrum.getMassSpectrometer());
            builder.append(" | ");
            builder.append("Type: ");
            builder.append(actualMassSpectrum.getMassSpectrumTypeDescription());
            builder.append(" | ");
        }
        builder.append("Signal: ");
        builder.append((int)massSpectrum.getTotalSignal());
        this.infoLabel.setText(builder.toString());
    }
}

