/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverterSupport;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.RegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.notifier.MassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassSpectrumSearchListUI;
import org.eclipse.chemclipse.msd.swt.ui.internal.runnables.ImportLibraryRunnable;
import org.eclipse.chemclipse.rcp.app.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MassSpectrumLibraryUI
extends Composite {
    private static final Logger logger = Logger.getLogger(MassSpectrumLibraryUI.class);
    private static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_IMPORT = "ACTION_IMPORT";
    private static final String ACTION_SELECT = "ACTION_SELECT";
    private MassSpectrumSearchListUI massSpectrumSearchListUI;
    private IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
    private IComparisonResult comparisonResult = ComparisonResult.createBestMatchComparisonResult();
    private Text textLibraryPath;
    private Button buttonSelectLibrary;
    private Button buttonMergeLibrary;
    private Button buttonCancel;
    private Button buttonDelete;
    private Button buttonAdd;
    private Button buttonImport;
    private IMassSpectra massSpectra;

    public MassSpectrumLibraryUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void update(IMassSpectra massSpectra, boolean forceReload) {
        this.massSpectra = massSpectra;
        this.massSpectrumSearchListUI.update(massSpectra, true);
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createButtonField(composite);
        this.createTableField(composite);
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private void createButtonField(Composite composite) {
        this.textLibraryPath = new Text(composite, 2048);
        this.textLibraryPath.setText("");
        this.textLibraryPath.setLayoutData((Object)new GridData(768));
        this.buttonSelectLibrary = new Button(composite, 8);
        this.buttonSelectLibrary.setText("Select Library");
        this.buttonSelectLibrary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumConverterSupport massSpectrumConverterSupport = MassSpectrumConverter.getMassSpectrumConverterSupport();
                try {
                    String[] extensions = massSpectrumConverterSupport.getFilterExtensions();
                    String[] names = massSpectrumConverterSupport.getFilterNames();
                    if (extensions.length == names.length) {
                        String[] filterExtensions = new String[extensions.length + 1];
                        String[] filterNames = new String[extensions.length + 1];
                        filterExtensions[0] = "*.*";
                        filterNames[0] = "All files";
                        int i = 0;
                        while (i < extensions.length) {
                            filterExtensions[i + 1] = extensions[i].replace(".", "*.");
                            filterNames[i + 1] = names[i];
                            ++i;
                        }
                        Shell shell = Display.getCurrent().getActiveShell();
                        FileDialog fileDialog = new FileDialog(shell, 8);
                        fileDialog.setText("Select Library");
                        fileDialog.setFilterExtensions(filterExtensions);
                        fileDialog.setFilterNames(filterNames);
                        fileDialog.setFilterPath(PreferenceSupplier.getPathMassSpectrumLibraries());
                        String pathname = fileDialog.open();
                        if (pathname != null) {
                            PreferenceSupplier.setPathMassSpectrumLibraries((String)fileDialog.getFilterPath());
                            MassSpectrumLibraryUI.this.textLibraryPath.setText(pathname);
                        }
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        final Shell shell = Display.getCurrent().getActiveShell();
        this.buttonMergeLibrary = new Button(composite, 8);
        this.buttonMergeLibrary.setText("Merge Library");
        this.buttonMergeLibrary.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        this.buttonMergeLibrary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pathLibrary = MassSpectrumLibraryUI.this.textLibraryPath.getText().trim();
                if ("".equals(pathLibrary)) {
                    MessageBox messageBox = new MessageBox(shell, 40);
                    messageBox.setText("Merge Library");
                    messageBox.setMessage("Please select a library.");
                    messageBox.open();
                } else {
                    File file = new File(MassSpectrumLibraryUI.this.textLibraryPath.getText().trim());
                    ImportLibraryRunnable runnable = new ImportLibraryRunnable(file);
                    ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
                    try {
                        monitor.run(true, true, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException e1) {
                        logger.warn((Object)e1);
                    }
                    catch (InterruptedException e1) {
                        logger.warn((Object)e1);
                    }
                    IMassSpectra massSpectraImport = runnable.getMassSpectra();
                    if (massSpectraImport != null) {
                        MassSpectrumLibraryUI.this.textLibraryPath.setText("");
                        MassSpectrumLibraryUI.this.massSpectra.addMassSpectra((Collection)massSpectraImport.getList());
                        MassSpectrumLibraryUI.this.massSpectrumSearchListUI.update(MassSpectrumLibraryUI.this.massSpectra, true);
                    }
                    MassSpectrumLibraryUI.this.enableButtonFields(MassSpectrumLibraryUI.ACTION_INITIALIZE);
                }
            }
        });
        Composite compositeButtons = new Composite(composite, 0);
        compositeButtons.setLayout((Layout)new GridLayout(4, true));
        GridData gridDataComposite = new GridData();
        gridDataComposite.horizontalAlignment = 131072;
        compositeButtons.setLayoutData((Object)gridDataComposite);
        this.buttonCancel = new Button(compositeButtons, 8);
        this.buttonCancel.setImage(ApplicationImageFactory.getInstance().getImage("cancel.gif", "16x16"));
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumLibraryUI.this.enableButtonFields(MassSpectrumLibraryUI.ACTION_CANCEL);
            }
        });
        this.buttonDelete = new Button(compositeButtons, 8);
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setImage(ApplicationImageFactory.getInstance().getImage("delete.gif", "16x16"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table = MassSpectrumLibraryUI.this.massSpectrumSearchListUI.getTableViewer().getTable();
                int index = table.getSelectionIndex();
                if (index >= 0) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 296);
                    messageBox.setText("Delete library entrie(s)?");
                    messageBox.setMessage("Would you like to delete the library entrie(s)?");
                    if (messageBox.open() == 32) {
                        TableItem[] tableItems;
                        MassSpectrumLibraryUI.this.enableButtonFields(MassSpectrumLibraryUI.ACTION_DELETE);
                        TableItem[] tableItemArray = tableItems = table.getSelection();
                        int n = tableItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            Object object = tableItem.getData();
                            if (object instanceof IScanMSD) {
                                IScanMSD massSpectrum = (IScanMSD)object;
                                MassSpectrumLibraryUI.this.massSpectra.removeMassSpectrum(massSpectrum);
                            }
                            ++n2;
                        }
                        MassSpectrumLibraryUI.this.massSpectrumSearchListUI.update(MassSpectrumLibraryUI.this.massSpectra, true);
                    }
                }
            }
        });
        this.buttonAdd = new Button(compositeButtons, 8);
        this.buttonAdd.setImage(ApplicationImageFactory.getInstance().getImage("add.gif", "16x16"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 290);
                messageBox.setText("Add library entry?");
                messageBox.setMessage("Would you like to add a new library entry?");
                if (messageBox.open() == 32) {
                    try {
                        String name = "Add a name";
                        RegularLibraryMassSpectrum libraryMassSpectrum = new RegularLibraryMassSpectrum();
                        ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
                        libraryInformation.setName(name);
                        libraryInformation.setComments("This library entry has been added manually");
                        libraryInformation.setMiscellaneous(ValueFormat.getDateFormatEnglish().format(new Date()));
                        libraryMassSpectrum.addIon((IIon)new Ion(18.0, 600.0f));
                        libraryMassSpectrum.addIon((IIon)new Ion(28.0, 1000.0f));
                        libraryMassSpectrum.addIon((IIon)new Ion(32.0, 250.0f));
                        MassSpectrumLibraryUI.this.massSpectra.addMassSpectrum((IScanMSD)libraryMassSpectrum);
                        MassSpectrumLibraryUI.this.massSpectrumSearchListUI.setSearchSelection(name);
                    }
                    catch (Exception e1) {
                        logger.warn((Object)e1);
                    }
                }
            }
        });
        this.buttonImport = new Button(compositeButtons, 8);
        this.buttonImport.setImage(ApplicationImageFactory.getInstance().getImage("import.png", "16x16"));
        this.buttonImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumLibraryUI.this.enableButtonFields(MassSpectrumLibraryUI.ACTION_IMPORT);
            }
        });
    }

    private void createTableField(Composite composite) {
        Composite compositeTable = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        compositeTable.setLayoutData((Object)gridData);
        compositeTable.setLayout((Layout)new FillLayout());
        Composite compositeInner = new Composite(compositeTable, 0);
        compositeInner.setLayout((Layout)new GridLayout(1, true));
        this.massSpectrumSearchListUI = new MassSpectrumSearchListUI(compositeInner, 2050);
        this.massSpectrumSearchListUI.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement != null && firstElement instanceof IScanMSD) {
                    ArrayList<String> viewIds = new ArrayList<String>();
                    viewIds.add("org.eclipse.chemclipse.ux.extension.msd.ui.part.simpleNominalMassSpectrumView");
                    viewIds.add("org.eclipse.chemclipse.ux.extension.msd.ui.part.massSpectrumTargetsView");
                    PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.ux.extension.msd.ui.perspective.massSpectrumLibrary", viewIds);
                    IScanMSD massSpectrum = (IScanMSD)firstElement;
                    MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)massSpectrum, (boolean)true);
                    IIdentificationTarget identificationTarget = MassSpectrumLibraryUI.this.getIdentificationTarget(massSpectrum);
                    MassSpectrumLibraryUI.this.eventBroker.send("identification/target/update", (Object)identificationTarget);
                    MassSpectrumLibraryUI.this.massSpectrumSearchListUI.setFocus();
                }
            }
        });
        this.massSpectrumSearchListUI.getTableViewer().getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumLibraryUI.this.enableButtonFields(MassSpectrumLibraryUI.ACTION_SELECT);
            }
        });
    }

    private void enableButtonFields(String action) {
        this.enableFields(false);
        switch (action) {
            case "ACTION_INITIALIZE": {
                this.buttonAdd.setEnabled(true);
                this.buttonImport.setEnabled(true);
                break;
            }
            case "ACTION_CANCEL": {
                this.buttonAdd.setEnabled(true);
                this.buttonImport.setEnabled(true);
                break;
            }
            case "ACTION_DELETE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_IMPORT": {
                this.buttonCancel.setEnabled(true);
                this.textLibraryPath.setEnabled(true);
                this.buttonSelectLibrary.setEnabled(true);
                this.buttonMergeLibrary.setEnabled(true);
                break;
            }
            case "ACTION_SELECT": {
                this.buttonAdd.setEnabled(true);
                this.buttonImport.setEnabled(true);
                if (this.massSpectrumSearchListUI.getTableViewer().getTable().getSelectionIndex() >= 0) {
                    this.buttonDelete.setEnabled(true);
                    break;
                }
                this.buttonDelete.setEnabled(false);
            }
        }
    }

    private void enableFields(boolean enabled) {
        this.buttonCancel.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.buttonImport.setEnabled(enabled);
        this.textLibraryPath.setEnabled(enabled);
        this.buttonSelectLibrary.setEnabled(enabled);
        this.buttonMergeLibrary.setEnabled(enabled);
    }

    private IIdentificationTarget getIdentificationTarget(IScanMSD scanMSD) {
        IRegularLibraryMassSpectrum libraryMassSpectrum;
        MassSpectrumTarget identificationTarget = null;
        ILibraryInformation libraryInformation = null;
        if (scanMSD instanceof IRegularLibraryMassSpectrum && (libraryInformation = (libraryMassSpectrum = (IRegularLibraryMassSpectrum)scanMSD).getLibraryInformation()) != null) {
            try {
                identificationTarget = new MassSpectrumTarget(libraryInformation, this.comparisonResult);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
        }
        return identificationTarget;
    }
}

