/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MassSpectraStackUI
extends Composite {
    private SimpleMassSpectrumUI noiseMassSpectrumUI;
    private IMassSpectra massSpectra;
    private IScanMSD actualMassSpectrum;
    private int index = 1;
    private Button buttonPrevious;
    private Button buttonNext;
    private Label labelDetails;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public MassSpectraStackUI(Composite parent, int style) {
        super(parent, style);
        this.initialize(parent);
    }

    public void update(IMassSpectra massSpectra, boolean forceReload) {
        this.massSpectra = massSpectra;
        this.index = 1;
        this.setMassSpectrum(this.index);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite compositeButtons = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        compositeButtons.setLayoutData((Object)gridData);
        compositeButtons.setLayout((Layout)new GridLayout(2, false));
        this.buttonPrevious = new Button(compositeButtons, 0);
        this.buttonPrevious.setImage(ApplicationImageFactory.getInstance().getImage("previous.gif", "16x16"));
        this.buttonPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectraStackUI.this.setPreviousMassSpectrum();
            }
        });
        this.buttonNext = new Button(compositeButtons, 0);
        this.buttonNext.setImage(ApplicationImageFactory.getInstance().getImage("next.gif", "16x16"));
        this.buttonNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectraStackUI.this.setNextMassSpectrum();
            }
        });
        this.labelDetails = new Label(composite, 0);
        this.labelDetails.setText("");
        this.labelDetails.setLayoutData((Object)new GridData(768));
        this.noiseMassSpectrumUI = new SimpleMassSpectrumUI(composite, 2052, MassValueDisplayPrecision.NOMINAL);
        this.noiseMassSpectrumUI.setLayoutData(new GridData(1808));
    }

    private final void setPreviousMassSpectrum() {
        --this.index;
        int min = 1;
        if (this.index < min) {
            this.index = min;
        }
        this.setMassSpectrum(this.index);
    }

    private final void setNextMassSpectrum() {
        ++this.index;
        int max = this.massSpectra.size();
        if (this.index > max) {
            this.index = max;
        }
        this.setMassSpectrum(this.index);
    }

    private void setMassSpectrum(int index) {
        int min = 1;
        int max = this.massSpectra.size();
        if (index == min) {
            this.buttonPrevious.setEnabled(false);
            this.buttonNext.setEnabled(true);
        } else if (index == max) {
            this.buttonPrevious.setEnabled(true);
            this.buttonNext.setEnabled(false);
        } else {
            this.buttonPrevious.setEnabled(true);
            this.buttonNext.setEnabled(true);
        }
        IScanMSD massSpectrum = this.massSpectra.getMassSpectrum(index);
        if (massSpectrum != null) {
            this.actualMassSpectrum = massSpectrum;
            this.setLabelDetails();
            this.noiseMassSpectrumUI.update(massSpectrum, true);
        }
    }

    private void setLabelDetails() {
        StringBuilder builder = new StringBuilder();
        IChromatogram chromatogram = this.actualMassSpectrum.getParentChromatogram();
        if (chromatogram != null) {
            builder.append("Chromatogram: ");
            builder.append(chromatogram.getName());
            builder.append(" | ");
        }
        builder.append("RT: ");
        builder.append(this.decimalFormat.format((double)this.actualMassSpectrum.getRetentionTime() / 60000.0));
        builder.append(" | ");
        builder.append("RI: ");
        if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
            builder.append(Integer.toString((int)this.actualMassSpectrum.getRetentionIndex()));
        } else {
            builder.append(this.decimalFormat.format(this.actualMassSpectrum.getRetentionIndex()));
        }
        builder.append(" | ");
        builder.append("TIC: ");
        builder.append(this.actualMassSpectrum.getTotalSignal());
        this.labelDetails.setText(builder.toString());
    }
}

