/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.chromatogram;

import java.util.Set;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.swt.ui.components.chromatogram.AbstractViewMSDChromatogramUI;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class ExcludedIonChromatogramUI
extends AbstractViewMSDChromatogramUI {
    public ExcludedIonChromatogramUI(Composite parent, int style) {
        super(parent, style);
    }

    public void setViewSeries() {
        Set excludedIonsNominal;
        IChromatogramSelectionMSD chromatogramSelection;
        IMarkedIons excludedIons;
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionMSD && (excludedIons = (chromatogramSelection = (IChromatogramSelectionMSD)storedChromatogramSelection).getExcludedIons()) != null && (excludedIonsNominal = excludedIons.getIonsNominal()).size() > 0) {
            ISeries series = SeriesConverter.convertChromatogram((IChromatogramSelection)chromatogramSelection, (Sign)Sign.POSITIVE, (boolean)true);
            this.addSeries(series);
            ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(Colors.BLACK);
            series = SeriesConverterMSD.convertChromatogramByExcludedIons(chromatogramSelection, excludedIons, Sign.POSITIVE);
            this.addSeries(series);
            lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(Colors.RED);
        }
    }
}

