/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.io.chromatogram;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.implementation.Peaks;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDWriter;
import org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.converter.MatlabParafacPeakExportConverter;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramMSDWriter {
    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        if (chromatogram == null || file == null) {
            throw new IOException("The chromatogram and the file must be not null.");
        }
        Peaks peaks = new Peaks();
        List chromatogramPeaks = chromatogram.getPeaks();
        for (IChromatogramPeakMSD chromatogramPeak : chromatogramPeaks) {
            peaks.addPeak((IPeak)chromatogramPeak);
        }
        MatlabParafacPeakExportConverter peakExportConverter = new MatlabParafacPeakExportConverter();
        peakExportConverter.convert(file, (IPeaks)peaks, false, monitor);
    }
}

