/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.views;

import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.notifier.ChromatogramSelectionCSDUpdateNotifier;
import org.eclipse.chemclipse.csd.swt.ui.components.peak.PeakListUI;
import org.eclipse.chemclipse.model.comparator.ChromatogramPeakComparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.implementation.Peaks;
import org.eclipse.chemclipse.model.selection.ChromatogramSelectionSupport;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.csd.ui.views.AbstractChromatogramSelectionCSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PeakListCSDView
extends AbstractChromatogramSelectionCSDView {
    private static final String POPUP_MENU_ID = "org.eclipse.chemclipse.chromatogram.csd.ui.perspective.views.peakListFIDView.popup";
    @Inject
    private Composite parent;
    private PeakListUI peakListUI;
    private IChromatogramPeakCSD firstPeak = null;
    private double firstIntegratedArea = 0.0;
    private IChromatogramPeakCSD lastPeak = null;
    private double lastIntegratedArea = 0.0;
    private IChromatogramSelectionCSD chromatogramSelectionMSDFocused;
    private ChromatogramPeakComparator chromatogramPeakComparator = new ChromatogramPeakComparator(SortOrder.ASC);
    private boolean peakDeleteUpdate = false;

    @Inject
    public PeakListCSDView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.peakListUI = new PeakListUI(this.parent, 0);
        final ExtendedTableViewer tableViewer = this.peakListUI.getTableViewer();
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                Object element;
                ISelection selection;
                if (event != null && (selection = event.getSelection()) instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IChromatogramPeakCSD) {
                    IChromatogramSelectionCSD chromatogramSelection = PeakListCSDView.this.getChromatogramSelection();
                    if (chromatogramSelection instanceof ChromatogramSelectionCSD) {
                        Display display = Display.getDefault();
                        try {
                            if (display != null) {
                                display.getCursorControl().setCursor(display.getSystemCursor(1));
                            }
                            IChromatogramPeakCSD selectedPeak = (IChromatogramPeakCSD)element;
                            ((ChromatogramSelectionCSD)chromatogramSelection).setSelectedPeak(selectedPeak, false);
                            if (PreferenceSupplier.isMoveRetentionTimeOnPeakSelection()) {
                                PeakListCSDView.this.adjustChromatogramSelection(selectedPeak, chromatogramSelection);
                            }
                            ChromatogramSelectionCSDUpdateNotifier.fireUpdateChange((IChromatogramSelectionCSD)chromatogramSelection, (boolean)true);
                        }
                        finally {
                            if (display != null) {
                                display.getCursorControl().setCursor(display.getSystemCursor(0));
                            }
                        }
                    }
                    chromatogramSelection = null;
                }
            }
        });
        tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    tableViewer.copyToClipboard(PeakListCSDView.this.peakListUI.getTitles());
                } else if (e.keyCode == 127 && e.stateMask == 0) {
                    PeakListCSDView.this.deleteSelectedPeaks();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.initContextMenu();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.peakListUI.getTableViewer().getControl().setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    @Override
    public void update(IChromatogramSelectionCSD chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            if (this.chromatogramSelectionMSDFocused == null || this.chromatogramSelectionMSDFocused != chromatogramSelection) {
                this.chromatogramSelectionMSDFocused = chromatogramSelection;
                List peakList = chromatogramSelection.getChromatogramCSD().getPeaks(chromatogramSelection);
                IPeaks peaks = this.getPeaks(peakList);
                this.peakListUI.update(peaks, forceReload);
            } else {
                this.updatePeaksInList(chromatogramSelection, forceReload);
            }
        } else if (chromatogramSelection == null) {
            this.chromatogramSelectionMSDFocused = null;
            if (this.isPartVisible()) {
                this.peakListUI.clear();
            }
        }
    }

    private void deleteSelectedPeaks() {
        Shell shell = Display.getCurrent().getActiveShell();
        MessageBox messageBox = new MessageBox(shell, 456);
        messageBox.setText("Delete Selected Peaks");
        messageBox.setMessage("Do you really want to delete the selected peaks?");
        int decision = messageBox.open();
        if (64 == decision) {
            this.peakDeleteUpdate = true;
            this.peakListUI.deleteSelectedPeaks(this.getChromatogramSelection());
        }
    }

    private void updatePeaksInList(IChromatogramSelectionCSD chromatogramSelection, boolean forceReload) {
        List peakList = chromatogramSelection.getChromatogramCSD().getPeaks(chromatogramSelection);
        int size = peakList.size();
        if (size > 0) {
            if (size == 1) {
                this.checkFirstPeakUpdate(peakList, forceReload);
            } else {
                this.checkFirstAndLastPeakUpdate(peakList, forceReload);
            }
        } else {
            this.peakListUI.clear();
            this.firstPeak = null;
            this.firstIntegratedArea = 0.0;
            this.lastPeak = null;
            this.lastIntegratedArea = 0.0;
        }
    }

    private void checkFirstPeakUpdate(List<IChromatogramPeakCSD> peakList, boolean forceReload) {
        IChromatogramPeakCSD peak = peakList.get(0);
        if (this.firstPeak != peak || this.peakDeleteUpdate) {
            this.peakDeleteUpdate = false;
            this.firstPeak = peak;
            this.firstIntegratedArea = peak.getIntegratedArea();
            IPeaks peaks = this.getPeaks(peakList);
            this.peakListUI.update(peaks, forceReload);
        } else if (this.reloadList(false)) {
            this.peakListUI.getTableViewer().refresh();
        }
    }

    private void checkFirstAndLastPeakUpdate(List<IChromatogramPeakCSD> peakList, boolean forceReload) {
        int size = peakList.size();
        IChromatogramPeakCSD peakOne = peakList.get(0);
        IChromatogramPeakCSD peakTwo = peakList.get(size - 1);
        if (this.firstPeak != peakOne || this.lastPeak != peakTwo || this.peakDeleteUpdate) {
            this.peakDeleteUpdate = false;
            this.firstPeak = peakOne;
            this.firstIntegratedArea = peakOne.getIntegratedArea();
            this.lastPeak = peakTwo;
            this.lastIntegratedArea = peakTwo.getIntegratedArea();
            IPeaks peaks = this.getPeaks(peakList);
            this.peakListUI.update(peaks, forceReload);
        } else if (this.reloadList(true)) {
            this.peakListUI.getTableViewer().refresh();
        }
    }

    private IPeaks getPeaks(List<IChromatogramPeakCSD> peakList) {
        Peaks peaks = new Peaks();
        for (IChromatogramPeakCSD peak : peakList) {
            peaks.addPeak((IPeak)peak);
        }
        return peaks;
    }

    private boolean reloadList(boolean checkSecondPeak) {
        if (this.firstPeak != null && this.firstPeak.getIntegratedArea() != this.firstIntegratedArea) {
            return true;
        }
        return checkSecondPeak && this.lastPeak != null && this.lastPeak.getIntegratedArea() != this.lastIntegratedArea;
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", POPUP_MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakListCSDView.this.peakListUI.getTableViewer().copyToClipboard(PeakListCSDView.this.peakListUI.getTitles());
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakListCSDView.this.deleteSelectedPeaks();
                    }
                };
                action.setText("Delete the selected peak(s)");
                manager.add((IAction)action);
            }
        });
        ExtendedTableViewer tableViewer = this.peakListUI.getTableViewer();
        Menu menu = menuManager.createContextMenu((Control)tableViewer.getTable());
        tableViewer.getTable().setMenu(menu);
    }

    private void adjustChromatogramSelection(IChromatogramPeakCSD selectedPeak, IChromatogramSelectionCSD chromatogramSelection) {
        IChromatogramCSD chromatogramCSD = chromatogramSelection.getChromatogramCSD();
        List peaks = chromatogramCSD.getPeaks();
        List peaksSelection = chromatogramCSD.getPeaks(chromatogramSelection);
        Collections.sort(peaks, this.chromatogramPeakComparator);
        Collections.sort(peaksSelection, this.chromatogramPeakComparator);
        if (!((IChromatogramPeakCSD)peaks.get(0)).equals(selectedPeak) && !((IChromatogramPeakCSD)peaks.get(peaks.size() - 1)).equals(selectedPeak)) {
            if (((IChromatogramPeakCSD)peaksSelection.get(0)).equals(selectedPeak)) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.LEFT, (int)5);
            } else if (((IChromatogramPeakCSD)peaksSelection.get(peaksSelection.size() - 1)).equals(selectedPeak)) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.RIGHT, (int)5);
            }
        }
    }
}

