/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceCatalogConfiguration
extends CatalogConfiguration
implements IMarketplaceClientConfiguration {
    private List<CatalogDescriptor> catalogDescriptors = new ArrayList<CatalogDescriptor>();
    private CatalogDescriptor catalogDescriptor;
    private String initialState;
    private Map<String, org.eclipse.epp.mpc.ui.Operation> initialOperations;
    private MarketplaceViewer.ContentType initialContentType;

    public MarketplaceCatalogConfiguration() {
        this.setShowTagFilter(false);
        this.setShowInstalled(true);
        this.setShowInstalledFilter(false);
        this.setVerifyUpdateSiteAvailability(true);
        this.setShowCategories(false);
    }

    public MarketplaceCatalogConfiguration(IMarketplaceClientConfiguration configuration) {
        this();
        this.setCatalogDescriptors(configuration.getCatalogDescriptors());
        this.setCatalogDescriptor(configuration.getCatalogDescriptor());
        this.setInitialState(configuration.getInitialState());
        this.setInitialOperations(configuration.getInitialOperations());
    }

    public MarketplaceViewer.ContentType getInitialContentType() {
        return this.initialContentType;
    }

    public void setInitialContentType(MarketplaceViewer.ContentType initialContentType) {
        this.initialContentType = initialContentType;
    }

    @Override
    public List<CatalogDescriptor> getCatalogDescriptors() {
        return this.catalogDescriptors;
    }

    @Override
    public void setCatalogDescriptors(List<CatalogDescriptor> catalogDescriptors) {
        this.catalogDescriptors = catalogDescriptors;
    }

    @Override
    public CatalogDescriptor getCatalogDescriptor() {
        return this.catalogDescriptor;
    }

    @Override
    public void setCatalogDescriptor(CatalogDescriptor catalogDescriptor) {
        this.catalogDescriptor = catalogDescriptor;
    }

    @Override
    public void setInitialState(Object state) {
        if (state != null && !(state instanceof String)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.MarketplaceCatalogConfiguration_invalidStateObject, (Object)state));
        }
        String stateString = (String)state;
        this.setInitialState(stateString);
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    @Override
    public String getInitialState() {
        return this.initialState;
    }

    @Override
    public Map<String, org.eclipse.epp.mpc.ui.Operation> getInitialOperations() {
        return this.initialOperations == null ? null : Collections.unmodifiableMap(this.initialOperations);
    }

    @Override
    public void setInitialOperations(Map<String, org.eclipse.epp.mpc.ui.Operation> initialOperations) {
        this.initialOperations = new LinkedHashMap<String, org.eclipse.epp.mpc.ui.Operation>(initialOperations);
    }

    @Deprecated
    public Map<String, Operation> getInitialOperationByNodeId() {
        Map<String, Operation> map = Operation.mapAll(this.initialOperations);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    @Deprecated
    public void setInitialOperationByNodeId(Map<String, Operation> initialOperationByNodeId) {
        this.initialOperations = Operation.mapAllBack(initialOperationByNodeId);
    }
}

