/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.report;

import java.io.File;
import org.eclipse.chemclipse.converter.processing.report.IReportImportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.report.ReportImportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.report.IReportImportConverter;
import org.eclipse.chemclipse.converter.report.ReportConverterSupport;
import org.eclipse.chemclipse.converter.report.ReportSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ReportConverter {
    private static final Logger logger = Logger.getLogger(ReportConverter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.converter.reportImportSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILE_EXTENSION = "fileExtension";
    private static final String FILE_NAME = "fileName";
    private static final String IMPORT_CONVERTER = "importConverter";

    private ReportConverter() {
    }

    public static IReportImportConverterProcessingInfo convert(File file, String converterId, IProgressMonitor monitor) {
        IReportImportConverter importConverter = ReportConverter.getReportImportConverter(converterId);
        IReportImportConverterProcessingInfo processingInfo = importConverter != null ? importConverter.convert(file, monitor) : ReportConverter.getNoImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    private static IReportImportConverter getReportImportConverter(String converterId) {
        IConfigurationElement element = ReportConverter.getConfigurationElement(converterId);
        IReportImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IReportImportConverter)element.createExecutableExtension(IMPORT_CONVERTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static ReportConverterSupport getReportConverterSupport() {
        IConfigurationElement[] extensions;
        ReportConverterSupport reportConverterSupport = new ReportConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ReportSupplier supplier = new ReportSupplier();
            supplier.setFileExtension(element.getAttribute(FILE_EXTENSION));
            supplier.setFileName(element.getAttribute(FILE_NAME));
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            reportConverterSupport.add(supplier);
            ++n2;
        }
        return reportConverterSupport;
    }

    private static IReportImportConverterProcessingInfo getNoImportConverterAvailableProcessingInfo(File file) {
        ReportImportConverterProcessingInfo processingInfo = new ReportImportConverterProcessingInfo();
        processingInfo.addErrorMessage("Report Import Converter", "There is no suitable converter available to load the report from the file: " + file.getAbsolutePath());
        return processingInfo;
    }
}

