/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.logging.ui;

import java.net.URL;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.chemclipse.logging.support.PropertiesUtil;
import org.eclipse.chemclipse.logging.ui.support.LoggerSupport;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String ICON_LOG = "ICON_LOG";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ImageRegistry imageRegistry = this.getImageRegistry();
        if (imageRegistry != null) {
            imageRegistry.put(ICON_LOG, this.createImageDescriptor(this.getBundle(), "icons/16x16/log.gif"));
        }
        this.initLogger();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void initLogger() {
        Properties properties = PropertiesUtil.getLog4jProperties();
        properties.setProperty("log4j.rootLogger", "DEBUG, ChemClipseConsoleAppender, ChemClipseFileAppender");
        try {
            PropertyConfigurator.configure((Properties)properties);
            LoggerSupport.getInstance().initConsole();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private ImageDescriptor createImageDescriptor(Bundle bundle, String string) {
        ImageDescriptor imageDescriptor = null;
        Path path = new Path(string);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        return imageDescriptor;
    }
}

