/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.converter;

import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.converter.core.AbstractMagicNumberMatcher;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.SpecificationValidator;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;

public class MagicNumberMatcherMSD
extends AbstractMagicNumberMatcher
implements IMagicNumberMatcher {
    public boolean checkFileFormat(File file) {
        boolean isForceLoadAlternateDetector = PreferenceSupplier.isForceLoadAlternateDetector();
        boolean isValidFormat = false;
        try {
            file = SpecificationValidator.validateSpecification(file);
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (!zipEntry.isDirectory()) continue;
                String name = zipEntry.getName();
                if (isForceLoadAlternateDetector) {
                    if (!name.equals("FID/CHROMATOGRAM/") && !name.equals("MSD/CHROMATOGRAM/") && !name.equals("WSD/CHROMATOGRAM/") && !name.equals("CHROMATOGRAM/")) continue;
                    isValidFormat = true;
                    break;
                }
                if (!name.equals("MSD/CHROMATOGRAM/") && !name.equals("CHROMATOGRAM/")) continue;
                isValidFormat = true;
                break;
            }
            zipFile.close();
        }
        catch (Exception exception) {}
        return isValidFormat;
    }
}

