/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ValueFormat {
    public static final String DEFAULT_DECIMAL_PATTERN = "0.###";
    public static final String DEFAULT_DATE_PATTERN = "yyyy/MM/dd";
    private static Map<String, DecimalFormat> decimalFormatsEnglish = null;
    private static Map<String, DecimalFormat> decimalFormatsGerman = null;
    private static Map<String, SimpleDateFormat> simpleDateFormatsEnglish = null;
    private static Map<String, SimpleDateFormat> simpleDateFormatsGerman = null;
    private static final String DEFAULT_NUMBER_FORMAT = "DNF";
    private static Map<String, NumberFormat> numberFormatsEnglish = null;

    static {
        decimalFormatsEnglish = new HashMap<String, DecimalFormat>();
        decimalFormatsGerman = new HashMap<String, DecimalFormat>();
        simpleDateFormatsEnglish = new HashMap<String, SimpleDateFormat>();
        simpleDateFormatsGerman = new HashMap<String, SimpleDateFormat>();
        numberFormatsEnglish = new HashMap<String, NumberFormat>();
    }

    private ValueFormat() {
    }

    public static DecimalFormat getDecimalFormatEnglish() {
        if (decimalFormatsEnglish.get(DEFAULT_DECIMAL_PATTERN) == null) {
            decimalFormatsEnglish.put(DEFAULT_DECIMAL_PATTERN, new DecimalFormat(DEFAULT_DECIMAL_PATTERN, new DecimalFormatSymbols(Locale.ENGLISH)));
        }
        return decimalFormatsEnglish.get(DEFAULT_DECIMAL_PATTERN);
    }

    public static DecimalFormat getDecimalFormatEnglishModifiable() {
        return new DecimalFormat(DEFAULT_DECIMAL_PATTERN, new DecimalFormatSymbols(Locale.ENGLISH));
    }

    public static DecimalFormat getDecimalFormatEnglish(String decimalPattern) {
        boolean patternIsValid = true;
        if (decimalFormatsEnglish.get(decimalPattern) == null) {
            try {
                decimalFormatsEnglish.put(decimalPattern, new DecimalFormat(decimalPattern, new DecimalFormatSymbols(Locale.ENGLISH)));
            }
            catch (Exception exception) {
                patternIsValid = false;
            }
        }
        if (patternIsValid) {
            return decimalFormatsEnglish.get(decimalPattern);
        }
        return ValueFormat.getDecimalFormatEnglish();
    }

    public static DecimalFormat getDecimalFormatEnglishModifiable(String decimalPattern) {
        DecimalFormat decimalFormat;
        try {
            decimalFormat = new DecimalFormat(decimalPattern, new DecimalFormatSymbols(Locale.ENGLISH));
        }
        catch (Exception exception) {
            decimalFormat = ValueFormat.getDecimalFormatEnglishModifiable();
        }
        return decimalFormat;
    }

    public static NumberFormat getNumberFormatEnglish() {
        if (numberFormatsEnglish.get(DEFAULT_NUMBER_FORMAT) == null) {
            numberFormatsEnglish.put(DEFAULT_NUMBER_FORMAT, NumberFormat.getInstance(Locale.ENGLISH));
        }
        return numberFormatsEnglish.get(DEFAULT_NUMBER_FORMAT);
    }

    public static NumberFormat getNumberFormatEnglish(int minimumFractionDigits, int maximumFractionDigits) {
        String key = String.valueOf(minimumFractionDigits) + " " + maximumFractionDigits;
        if (numberFormatsEnglish.get(key) == null) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setMinimumFractionDigits(minimumFractionDigits);
            numberFormat.setMaximumFractionDigits(maximumFractionDigits);
            numberFormatsEnglish.put(key, numberFormat);
        }
        return numberFormatsEnglish.get(key);
    }

    public static SimpleDateFormat getDateFormatEnglish() {
        if (simpleDateFormatsEnglish.get(DEFAULT_DATE_PATTERN) == null) {
            simpleDateFormatsEnglish.put(DEFAULT_DATE_PATTERN, new SimpleDateFormat(DEFAULT_DATE_PATTERN));
        }
        return simpleDateFormatsEnglish.get(DEFAULT_DATE_PATTERN);
    }

    public static SimpleDateFormat getDateFormatEnglish(String datePattern) {
        boolean patternIsValid = true;
        if (simpleDateFormatsEnglish.get(datePattern) == null) {
            try {
                simpleDateFormatsEnglish.put(datePattern, new SimpleDateFormat(datePattern));
            }
            catch (Exception exception) {
                patternIsValid = false;
            }
        }
        if (patternIsValid) {
            return simpleDateFormatsEnglish.get(datePattern);
        }
        return ValueFormat.getDateFormatEnglish();
    }

    public static DecimalFormat getDecimalFormatGerman() {
        if (decimalFormatsGerman.get(DEFAULT_DECIMAL_PATTERN) == null) {
            decimalFormatsGerman.put(DEFAULT_DECIMAL_PATTERN, new DecimalFormat(DEFAULT_DECIMAL_PATTERN, new DecimalFormatSymbols(Locale.GERMAN)));
        }
        return decimalFormatsGerman.get(DEFAULT_DECIMAL_PATTERN);
    }

    public static SimpleDateFormat getDateFormatGerman() {
        if (simpleDateFormatsGerman.get(DEFAULT_DATE_PATTERN) == null) {
            simpleDateFormatsGerman.put(DEFAULT_DATE_PATTERN, new SimpleDateFormat("dd.MM.yyyy"));
        }
        return simpleDateFormatsGerman.get(DEFAULT_DATE_PATTERN);
    }
}

