/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.peak;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.IPeakIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.IPeakIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.IPeakIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.PeakIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakIdentifier {
    private static final Logger logger = Logger.getLogger(PeakIdentifier.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.identifier.peakIdentifier";
    private static final String NO_IDENTIFIER_AVAILABLE = "There is no suitable peak identifier available";

    private PeakIdentifier() {
    }

    public static IPeakIdentifierProcessingInfo identify(IPeakMSD peak, IPeakIdentifierSettings identifierSettings, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifier peakIdentifier = PeakIdentifier.getPeakIdentifier(identifierId);
        IPeakIdentifierProcessingInfo processingInfo = peakIdentifier != null ? peakIdentifier.identify(peak, identifierSettings, monitor) : PeakIdentifier.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIdentifierProcessingInfo identify(IPeakMSD peak, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifier peakIdentifier = PeakIdentifier.getPeakIdentifier(identifierId);
        IPeakIdentifierProcessingInfo processingInfo = peakIdentifier != null ? peakIdentifier.identify(peak, monitor) : PeakIdentifier.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIdentifierProcessingInfo identify(List<IPeakMSD> peaks, IPeakIdentifierSettings identifierSettings, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifier peakIdentifier = PeakIdentifier.getPeakIdentifier(identifierId);
        IPeakIdentifierProcessingInfo processingInfo = peakIdentifier != null ? peakIdentifier.identify(peaks, identifierSettings, monitor) : PeakIdentifier.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIdentifierProcessingInfo identify(List<IPeakMSD> peaks, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifier peakIdentifier = PeakIdentifier.getPeakIdentifier(identifierId);
        IPeakIdentifierProcessingInfo processingInfo = peakIdentifier != null ? peakIdentifier.identify(peaks, monitor) : PeakIdentifier.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIdentifierSupport getPeakIdentifierSupport() {
        IConfigurationElement[] extensions;
        PeakIdentifierSupport identifierSupport = new PeakIdentifierSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PeakIdentifierSupplier supplier = new PeakIdentifierSupplier();
            supplier.setId(element.getAttribute("id"));
            supplier.setDescription(element.getAttribute("description"));
            supplier.setIdentifierName(element.getAttribute("identifierName"));
            identifierSupport.add(supplier);
            ++n2;
        }
        return identifierSupport;
    }

    private static IPeakIdentifier getPeakIdentifier(String identifierId) {
        IConfigurationElement element = PeakIdentifier.getConfigurationElement(identifierId);
        IPeakIdentifier instance = null;
        if (element != null) {
            try {
                instance = (IPeakIdentifier)element.createExecutableExtension("identifier");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IPeakIdentifierProcessingInfo getNoIdentifierAvailableProcessingInfo() {
        PeakIdentifierProcessingInfo processingInfo = new PeakIdentifierProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Peak Identifier", NO_IDENTIFIER_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

