/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner_D64;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class MatrixFeatures {
    public static boolean hasNaN(D1Matrix64F m) {
        int length = m.getNumElements();
        int i = 0;
        while (i < length) {
            if (Double.isNaN(m.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasUncountable(D1Matrix64F m) {
        int length = m.getNumElements();
        int i = 0;
        while (i < length) {
            double a = m.get(i);
            if (Double.isNaN(a) || Double.isInfinite(a)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isZeros(D1Matrix64F m, double tol) {
        int length = m.getNumElements();
        int i = 0;
        while (i < length) {
            if (Math.abs(m.get(i)) > tol) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isVector(Matrix mat) {
        return mat.getNumCols() == 1 || mat.getNumRows() == 1;
    }

    public static boolean isPositiveDefinite(DenseMatrix64F A) {
        if (!MatrixFeatures.isSquare(A)) {
            return false;
        }
        CholeskyDecompositionInner_D64 chol = new CholeskyDecompositionInner_D64(true);
        if (chol.inputModified()) {
            A = A.copy();
        }
        return chol.decompose(A);
    }

    public static boolean isPositiveSemidefinite(DenseMatrix64F A) {
        if (!MatrixFeatures.isSquare(A)) {
            return false;
        }
        EigenDecomposition<DenseMatrix64F> eig = DecompositionFactory.eig(A.numCols, false);
        if (eig.inputModified()) {
            A = A.copy();
        }
        eig.decompose(A);
        int i = 0;
        while (i < A.numRows) {
            Complex64F v = eig.getEigenvalue(i);
            if (v.getReal() < 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSquare(D1Matrix64F mat) {
        return mat.numCols == mat.numRows;
    }

    public static boolean isSymmetric(DenseMatrix64F m, double tol) {
        if (m.numCols != m.numRows) {
            return false;
        }
        double max = CommonOps.elementMaxAbs(m);
        int i = 0;
        while (i < m.numRows) {
            int j = 0;
            while (j < i) {
                double b;
                double a = m.get(i, j) / max;
                double diff = Math.abs(a - (b = m.get(j, i) / max));
                if (!(diff <= tol)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSymmetric(DenseMatrix64F m) {
        return MatrixFeatures.isSymmetric(m, 0.0);
    }

    public static boolean isSkewSymmetric(DenseMatrix64F A, double tol) {
        if (A.numCols != A.numRows) {
            return false;
        }
        int i = 0;
        while (i < A.numRows) {
            int j = 0;
            while (j < i) {
                double b;
                double a = A.get(i, j);
                double diff = Math.abs(a + (b = A.get(j, i)));
                if (!(diff <= tol)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInverse(DenseMatrix64F a, DenseMatrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        int numRows = a.numRows;
        int numCols = a.numCols;
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                double total = 0.0;
                int k = 0;
                while (k < numCols) {
                    total += a.get(i, k) * b.get(k, j);
                    ++k;
                }
                if (i == j ? !(Math.abs(total - 1.0) <= tol) : !(Math.abs(total) <= tol)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(D1Matrix64F a, D1Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        if (tol == 0.0) {
            return MatrixFeatures.isEquals(a, b);
        }
        int length = a.getNumElements();
        int i = 0;
        while (i < length) {
            if (!(tol >= Math.abs(a.get(i) - b.get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEqualsTriangle(RealMatrix64F a, RealMatrix64F b, boolean upper, double tol) {
        if (a.getNumRows() != b.getNumRows() || a.getNumCols() != b.getNumCols()) {
            return false;
        }
        if (upper) {
            int i = 0;
            while (i < a.getNumRows()) {
                int j = i;
                while (j < a.getNumCols()) {
                    if (Math.abs(a.get(i, j) - b.get(i, j)) > tol) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < a.getNumRows()) {
                int end = Math.min(i, a.getNumCols() - 1);
                int j = 0;
                while (j <= end) {
                    if (Math.abs(a.get(i, j) - b.get(i, j)) > tol) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isEquals(D1Matrix64F a, D1Matrix64F b) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        int length = a.getNumElements();
        int i = 0;
        while (i < length) {
            if (a.get(i) != b.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIdentical(D1Matrix64F a, D1Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        if (tol < 0.0) {
            throw new IllegalArgumentException("Tolerance must be greater than or equal to zero.");
        }
        int length = a.getNumElements();
        int i = 0;
        while (i < length) {
            double valB;
            double valA = a.get(i);
            double diff = Math.abs(valA - (valB = b.get(i)));
            if (!(tol >= diff)) {
                if (Double.isNaN(valA)) {
                    return Double.isNaN(valB);
                }
                if (Double.isInfinite(valA)) {
                    return valA == valB;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrthogonal(DenseMatrix64F Q, double tol) {
        if (Q.numRows < Q.numCols) {
            throw new IllegalArgumentException("The number of rows must be more than or equal to the number of columns");
        }
        DenseMatrix64F[] u = CommonOps.columnsToVector(Q, null);
        int i = 0;
        while (i < u.length) {
            DenseMatrix64F a = u[i];
            int j = i + 1;
            while (j < u.length) {
                double val = VectorVectorMult.innerProd(a, u[j]);
                if (!(Math.abs(val) <= tol)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRowsLinearIndependent(DenseMatrix64F A) {
        LUDecomposition<DenseMatrix64F> lu = DecompositionFactory.lu(A.numRows, A.numCols);
        if (lu.inputModified()) {
            A = A.copy();
        }
        if (!lu.decompose(A)) {
            throw new RuntimeException("Decompositon failed?");
        }
        return !lu.isSingular();
    }

    public static boolean isIdentity(DenseMatrix64F mat, double tol) {
        int index = 0;
        int i = 0;
        while (i < mat.numRows) {
            int j = 0;
            while (j < mat.numCols) {
                if (i == j ? !(Math.abs(mat.get(index++) - 1.0) <= tol) : !(Math.abs(mat.get(index++)) <= tol)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isConstantVal(DenseMatrix64F mat, double val, double tol) {
        int index = 0;
        int i = 0;
        while (i < mat.numRows) {
            int j = 0;
            while (j < mat.numCols) {
                if (!(Math.abs(mat.get(index++) - val) <= tol)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDiagonalPositive(DenseMatrix64F a) {
        int i = 0;
        while (i < a.numRows) {
            if (!(a.get(i, i) >= 0.0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isFullRank(DenseMatrix64F a) {
        throw new RuntimeException("Implement");
    }

    public static boolean isNegative(D1Matrix64F a, D1Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            throw new IllegalArgumentException("Matrix dimensions must match");
        }
        int length = a.getNumElements();
        int i = 0;
        while (i < length) {
            if (!(Math.abs(a.get(i) + b.get(i)) <= tol)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUpperTriangle(DenseMatrix64F A, int hessenberg, double tol) {
        if (A.numRows != A.numCols) {
            return false;
        }
        int i = hessenberg + 1;
        while (i < A.numRows) {
            int j = 0;
            while (j < i - hessenberg) {
                if (!(Math.abs(A.get(i, j)) <= tol)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static int rank(DenseMatrix64F A) {
        return MatrixFeatures.rank(A, UtilEjml.EPS * 100.0);
    }

    public static int rank(DenseMatrix64F A, double threshold) {
        SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(A.numRows, A.numCols, false, false, true);
        if (svd.inputModified()) {
            A = A.copy();
        }
        if (!svd.decompose(A)) {
            throw new RuntimeException("Decomposition failed");
        }
        return SingularOps.rank(svd, threshold);
    }

    public static int nullity(DenseMatrix64F A) {
        return MatrixFeatures.nullity(A, UtilEjml.EPS * 100.0);
    }

    public static int nullity(DenseMatrix64F A, double threshold) {
        SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(A.numRows, A.numCols, false, false, true);
        if (svd.inputModified()) {
            A = A.copy();
        }
        if (!svd.decompose(A)) {
            throw new RuntimeException("Decomposition failed");
        }
        return SingularOps.nullity(svd, threshold);
    }
}

