/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.svd;

import org.ejml.alg.dense.decomposition.bidiagonal.BidiagonalDecompositionRow_D64;
import org.ejml.alg.dense.decomposition.svd.SvdImplicitQrAlgorithmSmart;
import org.ejml.alg.dense.decomposition.svd.implicitqr.SvdImplicitQrAlgorithm;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class SvdImplicitQrDecompose_UltimateS
implements SingularValueDecomposition<DenseMatrix64F> {
    private int numRows;
    private int numCols;
    private int smallSide;
    private BidiagonalDecompositionRow_D64 bidiag = new BidiagonalDecompositionRow_D64();
    private SvdImplicitQrAlgorithm qralg = new SvdImplicitQrAlgorithmSmart();
    private double[] diag;
    private double[] off;
    private DenseMatrix64F Ut;
    private DenseMatrix64F Vt;
    private double[] singularValues;
    private int numSingular;
    private boolean compact;
    private boolean computeU;
    private boolean computeV;
    private boolean prefComputeU;
    private boolean prefComputeV;
    private double[] diagOld;
    private double[] offOld;
    private DenseMatrix64F A_mod = new DenseMatrix64F(1, 1);

    public SvdImplicitQrDecompose_UltimateS(boolean compact, boolean computeU, boolean computeV) {
        this.compact = compact;
        this.prefComputeU = computeU;
        this.prefComputeV = computeV;
    }

    @Override
    public double[] getSingularValues() {
        return this.singularValues;
    }

    @Override
    public int numberOfSingularValues() {
        return this.numSingular;
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    @Override
    public DenseMatrix64F getU(DenseMatrix64F U, boolean transpose) {
        if (!this.prefComputeU) {
            throw new IllegalArgumentException("As requested U was not computed.");
        }
        if (transpose) {
            return this.Ut;
        }
        U = new DenseMatrix64F(this.Ut.numCols, this.Ut.numRows);
        CommonOps.transpose(this.Ut, U);
        return U;
    }

    @Override
    public DenseMatrix64F getV(DenseMatrix64F V, boolean transpose) {
        if (!this.prefComputeV) {
            throw new IllegalArgumentException("As requested V was not computed.");
        }
        if (transpose) {
            return this.Vt;
        }
        V = new DenseMatrix64F(this.Vt.numCols, this.Vt.numRows);
        CommonOps.transpose(this.Vt, V);
        return V;
    }

    @Override
    public DenseMatrix64F getW(DenseMatrix64F W) {
        int n;
        int m = this.compact ? this.numSingular : this.numRows;
        int n2 = n = this.compact ? this.numSingular : this.numCols;
        if (W == null) {
            W = new DenseMatrix64F(m, n);
        } else {
            W.reshape(m, n, false);
            W.zero();
        }
        int i = 0;
        while (i < this.numSingular) {
            W.data[i * W.numCols + i] = this.singularValues[i];
            ++i;
        }
        return W;
    }

    @Override
    public boolean decompose(DenseMatrix64F orig) {
        boolean transposed = orig.numCols > orig.numRows;
        this.init(orig, transposed);
        if (this.computeSingularValues(orig, transposed)) {
            return false;
        }
        if ((this.computeU || this.computeV) && this.computeUandV(transposed)) {
            return false;
        }
        this.makeSingularPositive();
        return true;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    private void init(DenseMatrix64F orig, boolean transposed) {
        if (transposed) {
            this.computeU = this.prefComputeV;
            this.computeV = this.prefComputeU;
        } else {
            this.computeU = this.prefComputeU;
            this.computeV = this.prefComputeV;
        }
        this.numRows = orig.numRows;
        this.numCols = orig.numCols;
        this.smallSide = Math.min(this.numRows, this.numCols);
        if (this.diagOld == null || this.diagOld.length < this.smallSide) {
            this.diagOld = new double[this.smallSide];
            this.offOld = new double[this.smallSide - 1];
            this.diag = new double[this.smallSide];
            this.off = new double[this.smallSide - 1];
        }
    }

    private boolean computeUandV(boolean transposed) {
        long pointA = System.currentTimeMillis();
        if (this.computeU) {
            this.Ut = this.bidiag.getU(this.Ut, true, this.compact);
        }
        if (this.computeV) {
            this.Vt = this.bidiag.getV(this.Vt, true, this.compact);
        }
        if (transposed) {
            this.qralg.initParam(this.numCols, this.numRows);
        } else {
            this.qralg.initParam(this.numRows, this.numCols);
        }
        this.diagOld = this.qralg.swapDiag(this.diagOld);
        this.offOld = this.qralg.swapOff(this.offOld);
        this.qralg.setFastValues(false);
        if (this.computeU) {
            this.qralg.setUt(this.Ut);
        }
        if (this.computeV) {
            this.qralg.setVt(this.Vt);
        }
        CommonOps.setIdentity(this.Ut);
        CommonOps.setIdentity(this.Vt);
        long pointB = System.currentTimeMillis();
        if (!this.qralg.process(this.diagOld)) {
            return true;
        }
        long pointC = System.currentTimeMillis();
        System.out.println("  bidiag UV " + (pointB - pointA) + " qr UV " + (pointC - pointB));
        if (transposed) {
            DenseMatrix64F temp = this.Vt;
            this.Vt = this.Ut;
            this.Ut = temp;
        }
        return false;
    }

    private boolean computeSingularValues(DenseMatrix64F orig, boolean transposed) {
        long pointA = System.currentTimeMillis();
        if (this.bidiagonalization(orig, transposed)) {
            return false;
        }
        long pointB = System.currentTimeMillis();
        this.bidiag.getDiagonal(this.diag, this.off);
        this.qralg.setMatrix(this.numRows, this.numCols, this.diag, this.off);
        System.arraycopy(this.diag, 0, this.diagOld, 0, this.smallSide);
        System.arraycopy(this.off, 0, this.offOld, 0, this.smallSide - 1);
        this.qralg.setFastValues(true);
        this.qralg.setUt(null);
        this.qralg.setVt(null);
        boolean ret = !this.qralg.process();
        long pointC = System.currentTimeMillis();
        System.out.println("  bidiag " + (pointB - pointA) + " qr W " + (pointC - pointB));
        return ret;
    }

    private boolean bidiagonalization(DenseMatrix64F orig, boolean transposed) {
        if (transposed) {
            this.A_mod.reshape(orig.numCols, orig.numRows, false);
            CommonOps.transpose(orig, this.A_mod);
        } else {
            this.A_mod.reshape(orig.numRows, orig.numCols, false);
            this.A_mod.set(orig);
        }
        return !this.bidiag.decompose(this.A_mod);
    }

    private void makeSingularPositive() {
        this.numSingular = this.qralg.getNumberOfSingularValues();
        this.singularValues = this.qralg.getSingularValues();
        int i = 0;
        while (i < this.numSingular) {
            double val = this.singularValues[i];
            if (val < 0.0) {
                this.singularValues[i] = -val;
                if (this.computeU) {
                    int start = i * this.Ut.numCols;
                    int stop = start + this.Ut.numCols;
                    int j = start;
                    while (j < stop) {
                        this.Ut.data[j] = -this.Ut.data[j];
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }
}

