/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.internal.core.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.exceptions.ClassifierException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIon;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIons;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;

public class Calculator {
    public IWncIons calculateIonPercentages(IChromatogramSelectionMSD chromatogramSelection, IWncIons wncIons) throws ClassifierException {
        Map<Integer, Double> ionAbundanceValues = this.extractIonValues(chromatogramSelection);
        double factorMax = this.calculateFactorMax(ionAbundanceValues);
        double factorSum = this.calculateFactorSum(ionAbundanceValues);
        IWncIons wncIonsEdited = this.calculateAndSetIntensityValues(ionAbundanceValues, wncIons, factorMax, factorSum);
        return wncIonsEdited;
    }

    private Map<Integer, Double> extractIonValues(IChromatogramSelectionMSD chromatogramSelection) {
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        HashMap<Integer, Double> ionAbundanceValues = new HashMap<Integer, Double>();
        int scan = startScan;
        while (scan <= stopScan) {
            IExtractedIonSignal scanSignals = chromatogram.getSupplierScan(scan).getExtractedIonSignal();
            Integer ion = scanSignals.getStartIon();
            while (ion <= scanSignals.getStopIon()) {
                double signal = scanSignals.getAbundance(ion.intValue());
                if (ionAbundanceValues.containsKey(ion)) {
                    ionAbundanceValues.put(ion, signal += ((Double)ionAbundanceValues.get(ion)).doubleValue());
                } else {
                    ionAbundanceValues.put(ion, signal);
                }
                ion = ion + 1;
            }
            ++scan;
        }
        return ionAbundanceValues;
    }

    private double calculateFactorMax(Map<Integer, Double> ionAbundanceValues) throws ClassifierException {
        double maxAbundance = Collections.max(ionAbundanceValues.values());
        if (maxAbundance == 0.0) {
            throw new ClassifierException("There is no max abundance value.");
        }
        return 100.0 / maxAbundance;
    }

    private double calculateFactorSum(Map<Integer, Double> ionAbundanceValues) throws ClassifierException {
        double sumAbundance = 0.0;
        for (Double value : ionAbundanceValues.values()) {
            sumAbundance += value.doubleValue();
        }
        if (sumAbundance == 0.0) {
            throw new ClassifierException("There is no abundance value.");
        }
        return 100.0 / sumAbundance;
    }

    private IWncIons calculateAndSetIntensityValues(Map<Integer, Double> ionAbundanceValues, IWncIons wncIons, double factorMax, double factorSum) {
        Set<Map.Entry<Integer, Double>> entrySet = ionAbundanceValues.entrySet();
        for (Map.Entry<Integer, Double> entry : entrySet) {
            double percentageMaxIntensity = factorMax * entry.getValue();
            double percentageSumIntensity = factorSum * entry.getValue();
            IWncIon wncIon = wncIons.getWNCIon(entry.getKey());
            if (wncIon == null) continue;
            wncIon.setPercentageMaxIntensity(percentageMaxIntensity);
            wncIon.setPercentageSumIntensity(percentageSumIntensity);
        }
        return wncIons;
    }
}

