/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.csd.filter.core.chromatogram;

import org.eclipse.chemclipse.chromatogram.csd.filter.core.chromatogram.ChromatogramFilterSupplierCSD;
import org.eclipse.chemclipse.chromatogram.csd.filter.core.chromatogram.ChromatogramFilterSupportCSD;
import org.eclipse.chemclipse.chromatogram.csd.filter.core.chromatogram.IChromatogramFilterCSD;
import org.eclipse.chemclipse.chromatogram.csd.filter.core.chromatogram.IChromatogramFilterSupportCSD;
import org.eclipse.chemclipse.chromatogram.filter.processing.ChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.processing.IChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramFilterCSD {
    private static final Logger logger = Logger.getLogger(ChromatogramFilterCSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.csd.filter.chromatogramFilterSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILTER = "filter";
    private static final String PROCESSING_DESCRIPTION = "Chromatogram Filter";
    private static final String NO_CHROMATOGRAM_FILTER_AVAILABLE = "There is no chromatogram filter available.";

    private ChromatogramFilterCSD() {
    }

    public static IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionCSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, String filterId, IProgressMonitor monitor) {
        ChromatogramFilterProcessingInfo processingInfo;
        IChromatogramFilterCSD chromatogramFilter = ChromatogramFilterCSD.getChromatogramFilter(filterId);
        if (chromatogramFilter != null) {
            processingInfo = chromatogramFilter.applyFilter(chromatogramSelection, chromatogramFilterSettings, monitor);
        } else {
            processingInfo = new ChromatogramFilterProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_CHROMATOGRAM_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionCSD chromatogramSelection, String filterId, IProgressMonitor monitor) {
        ChromatogramFilterProcessingInfo processingInfo;
        IChromatogramFilterCSD chromatogramFilter = ChromatogramFilterCSD.getChromatogramFilter(filterId);
        if (chromatogramFilter != null) {
            processingInfo = chromatogramFilter.applyFilter(chromatogramSelection, monitor);
        } else {
            processingInfo = new ChromatogramFilterProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_CHROMATOGRAM_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IChromatogramFilterSupportCSD getChromatogramFilterSupport() {
        IConfigurationElement[] extensions;
        ChromatogramFilterSupportCSD filterSupport = new ChromatogramFilterSupportCSD();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramFilterSupplierCSD supplier = new ChromatogramFilterSupplierCSD();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            filterSupport.add(supplier);
            ++n2;
        }
        return filterSupport;
    }

    private static IChromatogramFilterCSD getChromatogramFilter(String filterId) {
        IConfigurationElement element = ChromatogramFilterCSD.getConfigurationElement(filterId);
        IChromatogramFilterCSD instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramFilterCSD)element.createExecutableExtension(FILTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

