/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.support.ICombinedMassSpectrumCalculator;

public class CombinedMassSpectrumCalculator
implements ICombinedMassSpectrumCalculator {
    private Map<Integer, Double> combinedMassSpectrum = new HashMap<Integer, Double>();

    @Override
    public void addIon(double ion, float abundance) {
        if (abundance == 0.0f) {
            return;
        }
        int key = AbstractIon.getIon(ion);
        if (this.combinedMassSpectrum.containsKey(key)) {
            this.combinedMassSpectrum.put(key, this.combinedMassSpectrum.get(key) + (double)abundance);
        } else {
            this.combinedMassSpectrum.put(key, Double.valueOf(abundance));
        }
    }

    @Override
    public void addIons(List<IIon> ions, IMarkedIons excludedIons) {
        if (ions == null || excludedIons == null) {
            return;
        }
        Set<Integer> excludedIonsNominal = excludedIons.getIonsNominal();
        for (IIon ion : ions) {
            if (excludedIonsNominal.contains(ion.getIon())) continue;
            this.addIon(ion.getIon(), ion.getAbundance());
        }
    }

    @Override
    public void removeIon(double ion) {
        int key = AbstractIon.getIon(ion);
        this.combinedMassSpectrum.remove(key);
    }

    @Override
    public void removeIons(IMarkedIons excludedIons) {
        for (Integer ion : excludedIons.getIonsNominal()) {
            this.combinedMassSpectrum.remove(ion);
        }
    }

    @Override
    public double getAbundance(double ion) {
        double result = 0.0;
        int key = AbstractIon.getIon(ion);
        if (this.combinedMassSpectrum.containsKey(key)) {
            result = this.combinedMassSpectrum.get(key);
        }
        return result;
    }

    @Override
    public Map<Integer, Double> getValues() {
        return this.combinedMassSpectrum;
    }

    @Override
    public void normalize(float normalizationFactor) {
        if (normalizationFactor <= 0.0f) {
            return;
        }
        double max = Collections.max(this.combinedMassSpectrum.values());
        if (max == 0.0) {
            return;
        }
        double correlationFactor = (double)normalizationFactor / max;
        for (Integer key : this.combinedMassSpectrum.keySet()) {
            double value = correlationFactor * this.combinedMassSpectrum.get(key);
            this.combinedMassSpectrum.put(key, value);
        }
    }
}

