/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.PeakIon;

public class PeakMassSpectrum
extends AbstractPeakMassSpectrum
implements IPeakMassSpectrum {
    private static final long serialVersionUID = -1105097569796396530L;
    private static final Logger logger = Logger.getLogger(PeakMassSpectrum.class);

    public PeakMassSpectrum() {
    }

    public PeakMassSpectrum(IPeakMassSpectrum peakMassSpectrum, float intensity) throws IllegalArgumentException {
        super(peakMassSpectrum, intensity);
    }

    public PeakMassSpectrum(IScanMSD massSpectrum) throws IllegalArgumentException {
        super(massSpectrum);
    }

    public PeakMassSpectrum(IScanMSD massSpectrum, float actualPercentageIntensity) throws IllegalArgumentException {
        super(massSpectrum, actualPercentageIntensity);
    }

    @Override
    public IScanMSD makeDeepCopy() throws CloneNotSupportedException {
        IPeakMassSpectrum massSpectrum = (IPeakMassSpectrum)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                PeakIon peakIon = new PeakIon(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon(peakIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

