/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.selection;

import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.AbstractChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIonTransitions;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIonTransitions;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramSelectionMSDUpdateNotifier;

public class ChromatogramSelectionMSD
extends AbstractChromatogramSelection
implements IChromatogramSelectionMSD {
    private IVendorMassSpectrum selectedScan;
    private IVendorMassSpectrum selectedIdentifiedScan;
    private IChromatogramPeakMSD selectedPeak;
    private IMarkedIons selectedIons = new MarkedIons();
    private IMarkedIons excludedIons = new MarkedIons();
    private IMarkedIonTransitions markedIonTransitions;

    public ChromatogramSelectionMSD(IChromatogram chromatogram) throws ChromatogramIsNullException {
        this(chromatogram, true);
    }

    public ChromatogramSelectionMSD(IChromatogram chromatogram, boolean fireUpdate) throws ChromatogramIsNullException {
        super(chromatogram, fireUpdate);
        IIonTransitionSettings ionTransitionSettings;
        this.markedIonTransitions = chromatogram instanceof IChromatogramMSD ? ((ionTransitionSettings = ((IChromatogramMSD)chromatogram).getIonTransitionSettings()) == null ? new MarkedIonTransitions() : new MarkedIonTransitions(ionTransitionSettings.getIonTransitions())) : new MarkedIonTransitions();
        this.reset(fireUpdate);
    }

    public void dispose() {
        super.dispose();
        this.selectedScan = null;
        this.selectedIdentifiedScan = null;
        this.selectedPeak = null;
        this.selectedIons = null;
        this.excludedIons = null;
    }

    @Override
    public IChromatogramMSD getChromatogramMSD() {
        IChromatogram chromatogram = this.getChromatogram();
        if (chromatogram instanceof IChromatogramMSD) {
            return (IChromatogramMSD)chromatogram;
        }
        return null;
    }

    @Override
    public IVendorMassSpectrum getSelectedScan() {
        return this.selectedScan;
    }

    @Override
    public IVendorMassSpectrum getSelectedIdentifiedScan() {
        return this.selectedIdentifiedScan;
    }

    @Override
    public IChromatogramPeakMSD getSelectedPeak() {
        return this.selectedPeak;
    }

    @Override
    public IMarkedIons getExcludedIons() {
        return this.excludedIons;
    }

    @Override
    public IMarkedIons getSelectedIons() {
        return this.selectedIons;
    }

    @Override
    public IMarkedIonTransitions getMarkedIonTransitions() {
        return this.markedIonTransitions;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean fireUpdate) {
        super.reset(fireUpdate);
        IChromatogram chromatogram = this.getChromatogram();
        if (chromatogram.getNumberOfScans() >= 1) {
            if (chromatogram instanceof IChromatogramMSD) {
                this.selectedScan = ((IChromatogramMSD)chromatogram).getSupplierScan(1);
            }
        } else {
            this.selectedScan = null;
        }
        this.selectedIdentifiedScan = null;
        if (chromatogram instanceof IChromatogramMSD) {
            List peaks = ((IChromatogramMSD)chromatogram).getPeaks();
            this.selectedPeak = peaks != null && peaks.size() >= 1 ? (IChromatogramPeakMSD)peaks.get(0) : null;
        }
        if (fireUpdate) {
            this.fireUpdateChange(false);
        }
    }

    public void setSelectedScan(IScan selectedScan) {
        if (selectedScan instanceof IVendorMassSpectrum) {
            this.setSelectedScan((IVendorMassSpectrum)selectedScan);
        }
    }

    public void setSelectedScan(IScan selectedScan, boolean update) {
        if (selectedScan instanceof IVendorMassSpectrum) {
            this.setSelectedScan((IVendorMassSpectrum)selectedScan, update);
        }
    }

    @Override
    public void setSelectedScan(IVendorMassSpectrum selectedScan) {
        this.setSelectedScan(selectedScan, true);
    }

    @Override
    public void setSelectedIdentifiedScan(IVendorMassSpectrum selectedIdentifiedScan) {
        this.setSelectedIdentifiedScan(selectedIdentifiedScan, true);
    }

    @Override
    public void setSelectedScan(IVendorMassSpectrum selectedScan, boolean update) {
        if (selectedScan != null) {
            this.selectedScan = selectedScan;
            if (update) {
                this.fireUpdateChange(false);
            }
        }
    }

    @Override
    public void setSelectedIdentifiedScan(IVendorMassSpectrum selectedIdentifiedScan, boolean update) {
        if (selectedIdentifiedScan != null) {
            this.selectedIdentifiedScan = selectedIdentifiedScan;
            if (update) {
                this.fireUpdateChange(false);
            }
        }
    }

    @Override
    public void setSelectedPeak(IChromatogramPeakMSD selectedPeak) {
        this.setSelectedPeak(selectedPeak, true);
    }

    @Override
    public void setSelectedPeak(IChromatogramPeakMSD selectedPeak, boolean update) {
        this.selectedPeak = selectedPeak;
        if (selectedPeak != null && update) {
            this.fireUpdateChange(false);
        }
    }

    public void fireUpdateChange(boolean forceReload) {
        try {
            ChromatogramSelectionMSDUpdateNotifier.fireUpdateChange(this, forceReload);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void update(boolean forceReload) {
        super.update(forceReload);
        this.setSelectedScan(this.selectedScan, false);
        this.setSelectedIdentifiedScan(this.selectedIdentifiedScan, false);
        this.setSelectedPeak(this.selectedPeak, false);
        this.fireUpdateChange(forceReload);
    }
}

