/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.quantitation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalsMSD;

public abstract class AbstractQuantitationSignalsMSD
implements IQuantitationSignalsMSD {
    private static final long serialVersionUID = 2941156198167427720L;
    private List<IQuantitationSignalMSD> quantitationSignals = new ArrayList<IQuantitationSignalMSD>();

    @Override
    public void add(IQuantitationSignalMSD quantitationSignalMSD) {
        this.quantitationSignals.add(quantitationSignalMSD);
    }

    @Override
    public void addAll(List<IQuantitationSignalMSD> quantitationSignals) {
        this.quantitationSignals.addAll(quantitationSignals);
    }

    @Override
    public void remove(IQuantitationSignalMSD quantitationSignalMSD) {
        this.quantitationSignals.remove(quantitationSignalMSD);
    }

    @Override
    public void removeAll(List<IQuantitationSignalMSD> quantitationSignalsMSD) {
        this.quantitationSignals.removeAll(quantitationSignalsMSD);
    }

    @Override
    public List<Double> getSelectedIons() {
        ArrayList<Double> ions = new ArrayList<Double>();
        for (IQuantitationSignalMSD quantitationSignal : this.quantitationSignals) {
            if (!quantitationSignal.isUse()) continue;
            ions.add(quantitationSignal.getIon());
        }
        return ions;
    }

    @Override
    public void clear() {
        this.quantitationSignals.clear();
    }

    @Override
    public int size() {
        return this.quantitationSignals.size();
    }

    @Override
    public IQuantitationSignalMSD get(int index) {
        return this.quantitationSignals.get(index);
    }

    @Override
    public List<IQuantitationSignalMSD> getList() {
        return this.quantitationSignals;
    }

    @Override
    public void deselectAllSignals() {
        this.setSignalsUse(false);
    }

    @Override
    public void selectAllSignals() {
        this.setSignalsUse(true);
    }

    private void setSignalsUse(boolean use) {
        for (IQuantitationSignalMSD quantitationSignal : this.quantitationSignals) {
            quantitationSignal.setUse(use);
        }
    }

    @Override
    public void selectSignal(double ion) {
        for (IQuantitationSignalMSD quantitationSignal : this.quantitationSignals) {
            if (quantitationSignal.getIon() != ion) continue;
            quantitationSignal.setUse(true);
        }
    }
}

