/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonBounds;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrumProxy;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;

public abstract class AbstractVendorMassSpectrumProxy
extends AbstractVendorMassSpectrum
implements IVendorMassSpectrumProxy {
    private static final long serialVersionUID = 6994933565324921239L;
    private boolean isProxy = true;
    private int numberOfIons;
    private float totalSignal;

    @Override
    public void setNumberOfIons(int numberOfIons) {
        this.numberOfIons = numberOfIons;
    }

    @Override
    public void setTotalSignal(float totalSignal) {
        this.totalSignal = totalSignal;
    }

    @Override
    public int getNumberOfIons() {
        if (this.isProxy) {
            return this.numberOfIons;
        }
        return super.getNumberOfIons();
    }

    @Override
    public float getTotalSignal() {
        if (this.isProxy) {
            return this.totalSignal;
        }
        return super.getTotalSignal();
    }

    @Override
    public boolean hasIons() {
        this.checkProxyAndImportOnDemand();
        return super.hasIons();
    }

    @Override
    public void enforceLoadScanProxy() {
        this.checkProxyAndImportOnDemand();
    }

    @Override
    public List<IIon> getIons() {
        this.checkProxyAndImportOnDemand();
        return super.getIons();
    }

    @Override
    public AbstractVendorMassSpectrumProxy addIons(List<IIon> ions, boolean addIntensities) {
        this.checkProxyAndImportOnDemand();
        super.addIons((List)ions, addIntensities);
        return this;
    }

    @Override
    public AbstractVendorMassSpectrumProxy addIon(IIon ion, boolean checked) {
        this.checkProxyAndImportOnDemand();
        super.addIon(ion, checked);
        return this;
    }

    @Override
    public AbstractVendorMassSpectrumProxy removeIon(IIon ion) {
        this.checkProxyAndImportOnDemand();
        super.removeIon(ion);
        return this;
    }

    @Override
    public AbstractVendorMassSpectrumProxy removeAllIons() {
        this.checkProxyAndImportOnDemand();
        super.removeAllIons();
        return this;
    }

    @Override
    public AbstractVendorMassSpectrumProxy removeIon(int ion) {
        this.checkProxyAndImportOnDemand();
        super.removeIon(ion);
        return this;
    }

    @Override
    public AbstractVendorMassSpectrumProxy removeIons(Set<Integer> ions) {
        this.checkProxyAndImportOnDemand();
        super.removeIons((Set)ions);
        return this;
    }

    @Override
    public AbstractVendorMassSpectrumProxy removeIons(IMarkedIons excludedIons) {
        this.checkProxyAndImportOnDemand();
        super.removeIons(excludedIons);
        return this;
    }

    @Override
    public float getTotalSignal(IMarkedIons excludedIons) {
        this.checkProxyAndImportOnDemand();
        return super.getTotalSignal(excludedIons);
    }

    @Override
    public double getBasePeak() {
        this.checkProxyAndImportOnDemand();
        return super.getBasePeak();
    }

    @Override
    public float getBasePeakAbundance() {
        this.checkProxyAndImportOnDemand();
        return super.getBasePeakAbundance();
    }

    @Override
    public IIon getHighestAbundance() {
        this.checkProxyAndImportOnDemand();
        return super.getHighestAbundance();
    }

    @Override
    public IIon getHighestIon() {
        this.checkProxyAndImportOnDemand();
        return super.getHighestIon();
    }

    @Override
    public IIon getLowestAbundance() {
        this.checkProxyAndImportOnDemand();
        return super.getLowestAbundance();
    }

    @Override
    public IIon getLowestIon() {
        this.checkProxyAndImportOnDemand();
        return super.getLowestIon();
    }

    @Override
    public IIonBounds getIonBounds() {
        this.checkProxyAndImportOnDemand();
        return super.getIonBounds();
    }

    @Override
    public IIon getIon(int ion) throws AbundanceLimitExceededException, IonLimitExceededException {
        this.checkProxyAndImportOnDemand();
        return super.getIon(ion);
    }

    @Override
    public IIon getIon(double ion) throws AbundanceLimitExceededException, IonLimitExceededException {
        this.checkProxyAndImportOnDemand();
        return super.getIon(ion);
    }

    @Override
    public IIon getIon(double ion, int precision) throws AbundanceLimitExceededException, IonLimitExceededException {
        this.checkProxyAndImportOnDemand();
        return super.getIon(ion, precision);
    }

    @Override
    public void adjustIons(float percentage) {
        this.checkProxyAndImportOnDemand();
        super.adjustIons(percentage);
    }

    @Override
    public void adjustTotalSignal(float totalSignal) {
        this.checkProxyAndImportOnDemand();
        super.adjustTotalSignal(totalSignal);
    }

    @Override
    public IScanMSD getMassSpectrum(IMarkedIons excludedIons) {
        this.checkProxyAndImportOnDemand();
        return super.getMassSpectrum(excludedIons);
    }

    @Override
    public IScanMSD normalize() {
        this.checkProxyAndImportOnDemand();
        return super.normalize();
    }

    @Override
    public IScanMSD normalize(float base) {
        this.checkProxyAndImportOnDemand();
        return super.normalize(base);
    }

    private void checkProxyAndImportOnDemand() {
        if (this.isProxy) {
            this.isProxy = false;
            this.importIons();
        }
    }
}

