/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.PeakIon;

public abstract class AbstractPeakMassSpectrum
extends AbstractRegularMassSpectrum
implements IPeakMassSpectrum {
    private static final long serialVersionUID = -7779014133066855210L;
    private static final Logger logger = Logger.getLogger(AbstractPeakMassSpectrum.class);

    public AbstractPeakMassSpectrum() {
    }

    public AbstractPeakMassSpectrum(IPeakMassSpectrum peakMassSpectrum, float intensity) throws IllegalArgumentException {
        if (peakMassSpectrum == null) {
            throw new IllegalArgumentException("The peakMassSpectrum must not be null");
        }
        if (intensity < 0.0f || intensity > 100.0f) {
            throw new IllegalArgumentException("The intensity must be >= 0 and <= IPeakIntensityValues.MAX_INTENSITY");
        }
        double intensityFactor = (double)intensity / 100.0;
        List ions = peakMassSpectrum.getIons();
        for (IIon ion : ions) {
            try {
                float abundance = (float)((double)ion.getAbundance() * intensityFactor);
                PeakIon peakIon = new PeakIon(ion.getIon(), abundance);
                this.addIon(peakIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    public AbstractPeakMassSpectrum(IScanMSD massSpectrum, float actualPercentageIntensity) throws IllegalArgumentException {
        if (massSpectrum == null) {
            throw new IllegalArgumentException("The massSpectrum must not be null");
        }
        if (actualPercentageIntensity <= 0.0f) {
            throw new IllegalArgumentException("The percentageIntensity must not be > 0.");
        }
        List ions = massSpectrum.getIons();
        for (IIon ion : ions) {
            try {
                float abundance = ion.getAbundance() / actualPercentageIntensity * 100.0f;
                PeakIon peakIon = new PeakIon(ion.getIon(), abundance);
                this.addIon(peakIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    public AbstractPeakMassSpectrum(IScanMSD massSpectrum) throws IllegalArgumentException {
        if (massSpectrum == null) {
            throw new IllegalArgumentException("The massSpectrum must not be null");
        }
        List ions = massSpectrum.getIons();
        for (IIon ion : ions) {
            try {
                PeakIon peakIon = new PeakIon(ion);
                this.addIon(peakIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    @Override
    public void addIon(IPeakIon peakIon, boolean checked) {
        super.addIon(peakIon, checked);
    }

    @Override
    public void addIon(IPeakIon peakIon) {
        super.addIon(peakIon);
    }
}

