/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.exceptions.IonIsNullException;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.IonTransitionIsNullException;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractIon
implements IIon {
    private static final long serialVersionUID = -2481473608026036078L;
    private double ion = 0.0;
    private float abundance = 0.0f;
    private static final int MAX_PRECISION = 6;
    private IIonTransition ionTransition;

    public AbstractIon(double ion) throws IonLimitExceededException {
        this.setIon(ion);
    }

    public AbstractIon(double ion, float abundance) throws AbundanceLimitExceededException, IonLimitExceededException {
        this.setIon(ion);
        this.setAbundance(abundance);
    }

    public AbstractIon(double ion, float abundance, IIonTransition ionTransition) throws AbundanceLimitExceededException, IonLimitExceededException, IonTransitionIsNullException {
        this.setIon(ion);
        this.setAbundance(abundance);
        if (ionTransition == null) {
            throw new IonTransitionIsNullException("The given ion transition instance should be not null.");
        }
        this.ionTransition = ionTransition;
    }

    public AbstractIon(IIon ion) throws AbundanceLimitExceededException, IonLimitExceededException, IonIsNullException {
        if (ion == null) {
            throw new IonIsNullException("The given ion instance should be not null.");
        }
        this.setIon(ion.getIon());
        this.setAbundance(ion.getAbundance());
    }

    public AbstractIon(IIon ion, IIonTransition ionTransition) throws AbundanceLimitExceededException, IonLimitExceededException, IonIsNullException, IonTransitionIsNullException {
        this(ion);
        if (ionTransition == null) {
            throw new IonTransitionIsNullException("The given ion transition instance should be not null.");
        }
        this.ionTransition = ionTransition;
    }

    public static int getIon(double ion) {
        return (int)Math.round(ion);
    }

    public static double getIon(double ion, int precision) {
        if (precision <= 0 || precision > 6) {
            precision = 1;
        }
        double factor = Math.pow(10.0, precision);
        return (double)Math.round(ion * factor) / factor;
    }

    public static int getAbundance(float abundance) {
        return Math.round(abundance);
    }

    @Override
    public float getAbundance() {
        return this.abundance;
    }

    @Override
    public double getIon() {
        return this.ion;
    }

    @Override
    public AbstractIon setAbundance(float abundance) throws AbundanceLimitExceededException {
        if (abundance < 0.0f) {
            throw new AbundanceLimitExceededException("The abundance value can't be negative. It is actual: " + abundance);
        }
        this.abundance = abundance;
        return this;
    }

    @Override
    public AbstractIon setIon(double ion) throws IonLimitExceededException {
        if (ion < 0.0) {
            throw new IonLimitExceededException("The ion value can't be negative. It is actual: " + ion);
        }
        this.ion = ion;
        return this;
    }

    @Override
    public IIonTransition getIonTransition() {
        return this.ionTransition;
    }

    @Override
    public int compareTo(IIon other) {
        return (int)(this.ion - other.getIon());
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractIon other = (AbstractIon)otherObject;
        return this.ion == other.getIon() && this.abundance == other.getAbundance() && this.ionTransition == other.getIonTransition();
    }

    public int hashCode() {
        int ionTransitionHashCode = 0;
        if (this.ionTransition != null) {
            ionTransitionHashCode = this.ionTransition.hashCode();
        }
        return 7 * new Double(this.ion).hashCode() + 11 * new Float(this.abundance).hashCode() + ionTransitionHashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("ion=" + this.ion);
        builder.append(",");
        builder.append("abundance=" + this.abundance);
        builder.append(",");
        builder.append("ionTransition=" + this.ionTransition);
        builder.append("]");
        return builder.toString();
    }
}

