/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ApplicationActionMenuControl {
    private Composite parent;
    private ApplicationAction selectedType;
    private String selectionButtonLabel;
    private Image selectionButtonImage;
    private Button applicationActionButton;
    private List<IButtonMenuListener> listeners;
    private FormToolkit toolkit;
    private ToolBar toolBar;
    private Composite buttonComposite;

    public ApplicationActionMenuControl(Composite parent, ApplicationAction defaultValue, String selectionButtonLabel, Image selectionButtonImage, FormToolkit toolkit) {
        this.parent = parent;
        this.selectedType = defaultValue;
        this.listeners = new ArrayList<IButtonMenuListener>();
        this.selectionButtonLabel = selectionButtonLabel;
        this.selectionButtonImage = selectionButtonImage;
        this.toolkit = toolkit;
    }

    public Button getSelectionButton() {
        return this.applicationActionButton;
    }

    public void setCompositeLayoutData(Object data) {
        if (this.buttonComposite != null) {
            this.buttonComposite.setLayoutData(data);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.applicationActionButton != null) {
            this.applicationActionButton.setVisible(isVisible);
        }
        if (this.toolBar != null) {
            this.toolBar.setVisible(isVisible);
        }
        if (this.buttonComposite != null) {
            this.buttonComposite.setVisible(isVisible);
        }
    }

    protected Button createButton(Composite parent, String text, Image image, int type) {
        Button button = this.toolkit != null ? this.toolkit.createButton(parent, text, type) : new Button(parent, type);
        button.setText(text);
        if (image != null) {
            button.setImage(image);
        }
        return button;
    }

    protected void notifyListeners() {
        for (IButtonMenuListener listener : this.listeners) {
            listener.widgetSelected(this.selectedType);
        }
    }

    protected void adaptControl(Control control) {
        if (this.toolkit != null) {
            control.setBackground(this.toolkit.getColors().getBackground());
            control.setForeground(this.toolkit.getColors().getForeground());
        }
    }

    protected ToolBarManager createToolBarManager(Composite parent) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl(parent);
        this.adaptControl((Control)toolBar);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 1).applyTo((Control)toolBar);
        return toolBarManager;
    }

    public void createControl() {
        this.buttonComposite = this.toolkit != null ? this.toolkit.createComposite(this.parent, 0) : new Composite(this.parent, 0);
        GridLayoutFactory.fillDefaults().spacing(new Point(0, 0)).numColumns(2).equalWidth(false).margins(0, 0).applyTo(this.buttonComposite);
        this.applicationActionButton = this.createButton(this.buttonComposite, this.selectionButtonLabel, this.selectionButtonImage, 0x800000);
        this.applicationActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationActionMenuControl.this.notifyListeners();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 1).applyTo((Control)this.applicationActionButton);
        this.setDefaultTooltipMessage();
        this.setVisible(true);
    }

    protected void showViewMenu(MenuManager manager, ToolBar toolBar) {
        if (!this.isVisible()) {
            return;
        }
        Menu menu = manager.createContextMenu((Control)this.applicationActionButton);
        this.applicationActionButton.setMenu(menu);
        Rectangle bounds = toolBar.getBounds();
        Point topRight = new Point(bounds.x + bounds.x / 10, bounds.height);
        topRight = this.applicationActionButton.toDisplay(topRight);
        menu.setLocation(topRight.x, topRight.y);
        menu.setVisible(true);
    }

    public boolean isVisible() {
        if (this.applicationActionButton != null) {
            return this.applicationActionButton.isVisible();
        }
        return false;
    }

    public IButtonMenuListener addMenuListener(IButtonMenuListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
            return listener;
        }
        return null;
    }

    public void setSelectedAction(ApplicationAction selectedType) {
        this.selectedType = selectedType;
        this.setDefaultTooltipMessage();
    }

    protected String getLabel(ApplicationAction action) {
        return action.getDisplayName();
    }

    public void setDefaultTooltipMessage() {
        if (this.applicationActionButton != null) {
            this.applicationActionButton.setToolTipText(NLS.bind((String)Messages.ApplicationActionMenuControl_TEXT_SELECT_MODE_FOR, (Object)this.selectedType.getDisplayName()));
        }
    }

    public static interface IButtonMenuListener {
        public void widgetSelected(ApplicationAction var1);
    }

    protected class MenuAction
    extends Action {
        private ApplicationAction type;

        public MenuAction(ApplicationAction type) {
            this.type = type;
            this.setText(type.getDisplayName() != null ? type.getDisplayName() : type.name());
        }

        public void run() {
            ApplicationActionMenuControl.this.setSelectedAction(this.type);
            ApplicationActionMenuControl.this.notifyListeners();
        }
    }
}

