/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.io.IOException;
import java.net.URI;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.client.AuthorizationHeaderProvider;
import org.eclipse.cft.server.core.internal.client.RestUtils;
import org.eclipse.cft.server.core.internal.client.diego.CFInfo;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.client.RestTemplate;

public class CFClientV1Support {
    protected final AuthorizationHeaderProvider oauth;
    protected final RestTemplate restTemplate;
    private final CFInfo cloudInfo;
    protected final String authorizationUrl;
    protected final CloudSpace existingSessionConnection;

    public CFClientV1Support(CloudFoundryOperations cfClient, CloudSpace existingSessionConnection, CFInfo cloudInfo, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSigned) {
        this.cloudInfo = cloudInfo;
        this.oauth = this.getHeaderProvider(cfClient);
        this.existingSessionConnection = existingSessionConnection;
        this.restTemplate = RestUtils.createRestTemplate(httpProxyConfiguration, trustSelfSigned, true);
        ClientHttpRequestFactory requestFactory = this.restTemplate.getRequestFactory();
        this.restTemplate.setRequestFactory(this.authorize(requestFactory));
        this.authorizationUrl = cloudInfo.getAuthorizationUrl();
    }

    protected CloudSpace getExistingConnectionSession() {
        return this.existingSessionConnection;
    }

    protected ClientHttpRequestFactory authorize(final ClientHttpRequestFactory delegate) {
        return new ClientHttpRequestFactory(){

            public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
                ClientHttpRequest request = delegate.createRequest(uri, httpMethod);
                request.getHeaders().add("Authorization", CFClientV1Support.this.oauth.getAuthorizationHeader());
                return request;
            }
        };
    }

    protected String getUrl(String path) {
        return String.valueOf(this.cloudInfo.getCloudControllerUrl()) + (path.startsWith("/") ? path : "/" + path);
    }

    protected AuthorizationHeaderProvider getHeaderProvider(final CloudFoundryOperations cfClient) {
        AuthorizationHeaderProvider oauth = new AuthorizationHeaderProvider(){

            @Override
            public String getAuthorizationHeader() {
                OAuth2AccessToken token = cfClient.login();
                return String.valueOf(token.getTokenType()) + " " + token.getValue();
            }
        };
        return oauth;
    }

    protected CFInfo getCloudInfo() {
        return this.cloudInfo;
    }
}

