/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.application.CloudZipApplicationArchive;
import org.eclipse.cft.server.core.internal.application.ManifestParser;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;

public class JavaWebApplicationDelegate
extends AbstractApplicationDelegate {
    protected static Map<String, String> getJavaWebSupportedFrameworks() {
        LinkedHashMap<String, String> valuesByLabel = new LinkedHashMap<String, String>();
        valuesByLabel.put("spring", "Spring");
        valuesByLabel.put("grails", "Grails");
        valuesByLabel.put("lift/1.0", "Lift");
        valuesByLabel.put("java_web", "Java Web");
        return valuesByLabel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getFramework(IProject project) {
        IJavaProject javaProject;
        if (project != null && (javaProject = CloudFoundryProjectUtil.getJavaProject(project)) != null) {
            if (CloudFoundryProjectUtil.hasNature((IResource)project, "com.springsource.sts.grails.core.nature")) {
                return "grails";
            }
            if (project.isAccessible() && project.getFolder("grails-app").exists() && project.getFile("application.properties").exists()) {
                return "grails";
            }
            boolean foundSpringLibrary = false;
            try {
                IClasspathEntry[] entries;
                IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathContainer container;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 1) {
                        if (this.isLiftLibrary(entry)) {
                            return "lift/1.0";
                        }
                        if (this.isSpringLibrary(entry)) {
                            foundSpringLibrary = true;
                        }
                    } else if (entry.getEntryKind() == 5 && (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject)) != null) {
                        IClasspathEntry[] iClasspathEntryArray2 = container.getClasspathEntries();
                        int n3 = iClasspathEntryArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IClasspathEntry childEntry = iClasspathEntryArray2[n4];
                            if (this.isLiftLibrary(childEntry)) {
                                return "lift/1.0";
                            }
                            if (this.isSpringLibrary(childEntry)) {
                                foundSpringLibrary = true;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                CloudFoundryPlugin.log((IStatus)new Status(2, "org.eclipse.cft.server.core", "Unexpected error during auto detection of application type", (Throwable)e));
            }
            if (CloudFoundryProjectUtil.isSpringProject((IResource)project)) {
                return "spring";
            }
            if (foundSpringLibrary) {
                return "spring";
            }
        }
        return null;
    }

    private boolean isLiftLibrary(IClasspathEntry entry) {
        if (entry.getPath() != null) {
            String name = entry.getPath().lastSegment();
            return Pattern.matches("lift-webkit.*\\.jar", name);
        }
        return false;
    }

    private boolean isSpringLibrary(IClasspathEntry entry) {
        if (entry.getPath() != null) {
            String name = entry.getPath().lastSegment();
            return Pattern.matches(".*spring.*\\.jar", name);
        }
        return false;
    }

    @Override
    public boolean requiresURL() {
        return true;
    }

    @Override
    public boolean providesApplicationArchive(IModule module) {
        return true;
    }

    @Override
    public ApplicationArchive getApplicationArchive(CloudFoundryApplicationModule module, CloudFoundryServer cloudServer, IModuleResource[] moduleResources, IProgressMonitor monitor) throws CoreException {
        ApplicationArchive manifestArchive = JavaWebApplicationDelegate.getArchiveFromManifest(module, cloudServer);
        if (manifestArchive != null) {
            return manifestArchive;
        }
        try {
            File warFile = CloudUtil.createWarFile(new IModule[]{module.getLocalModule()}, (Server)cloudServer.getServer(), monitor);
            CloudFoundryPlugin.trace("War file " + warFile.getName() + " created");
            return new CloudZipApplicationArchive(new ZipFile(warFile));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "Failed to create war file. \nApplication: " + module.getApplication().getName() + "\nModule: " + module.getName() + "\nException: " + e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public IStatus validateDeploymentInfo(ApplicationDeploymentInfo deploymentInfo) {
        IStatus status = super.validateDeploymentInfo(deploymentInfo);
        if (status.isOK() && (deploymentInfo.getUris() == null || deploymentInfo.getUris().isEmpty())) {
            String errorMessage = Messages.JavaWebApplicationDelegate_ERROR_NO_MAPPED_APP_URL;
            status = CloudFoundryPlugin.getErrorStatus(errorMessage);
        }
        return status;
    }

    @Override
    public ApplicationDeploymentInfo getDefaultApplicationDeploymentInfo(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, IProgressMonitor monitor) throws CoreException {
        ApplicationDeploymentInfo info = super.getDefaultApplicationDeploymentInfo(appModule, cloudServer, monitor);
        if ((info.getUris() == null || info.getUris().isEmpty()) && info.getDeploymentName() != null) {
            CloudApplicationURL url = ApplicationUrlLookupService.update(cloudServer, monitor).getDefaultApplicationURL(info.getDeploymentName());
            info.setUris(Arrays.asList(url.getUrl()));
        }
        return info;
    }

    public static ApplicationArchive getArchiveFromManifest(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) throws CoreException {
        String archivePath = null;
        ManifestParser parser = new ManifestParser(appModule, cloudServer);
        if (parser.hasManifest()) {
            archivePath = parser.getApplicationProperty(null, "path");
        }
        File packagedFile = null;
        if (archivePath != null) {
            Path path = new Path(archivePath);
            if (path.getFileExtension() != null) {
                IFile projectRelativeFile = null;
                IProject project = CloudFoundryProjectUtil.getProject(appModule);
                if (project != null) {
                    projectRelativeFile = project.getFile(archivePath);
                }
                if (projectRelativeFile != null && projectRelativeFile.exists()) {
                    packagedFile = projectRelativeFile.getLocation().toFile();
                } else {
                    File absoluteFile = new File(archivePath);
                    if (absoluteFile.exists() && absoluteFile.canRead()) {
                        packagedFile = absoluteFile;
                    }
                }
            }
            if (packagedFile == null) {
                String message = NLS.bind((String)Messages.JavaWebApplicationDelegate_ERROR_FILE_NOT_FOUND_MANIFEST_YML, (Object)archivePath);
                throw CloudErrorUtil.toCoreException(message);
            }
            try {
                return new CloudZipApplicationArchive(new ZipFile(packagedFile));
            }
            catch (ZipException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
            catch (IOException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
        }
        return null;
    }
}

