/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import javax.net.ssl.SSLPeerUnverifiedException;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.ui.internal.CloudSpacesDelegate;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.IEventSource;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.ServerValidator;
import org.eclipse.cft.server.ui.internal.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class ServerWizardValidator
implements ServerValidator {
    private final CloudFoundryServer cfServer;
    private final CloudSpacesDelegate cloudServerSpaceDelegate;
    private final IEventSource<ServerWizardValidator> validatorEventSource = new IEventSource<ServerWizardValidator>(){

        @Override
        public ServerWizardValidator getSource() {
            return ServerWizardValidator.this;
        }
    };

    public ServerWizardValidator(CloudFoundryServer cloudServer, CloudSpacesDelegate cloudServerSpaceDelegate) {
        this.cfServer = cloudServer;
        this.cloudServerSpaceDelegate = cloudServerSpaceDelegate;
    }

    public CloudSpacesDelegate getSpaceDelegate() {
        return this.cloudServerSpaceDelegate;
    }

    public CloudFoundryServer getCloudFoundryServer() {
        return this.cfServer;
    }

    public ValidationStatus localValidation() {
        return this.validate(false, true, null);
    }

    @Override
    public synchronized ValidationStatus validate(boolean validateAgainstServer, boolean validateSpace, IRunnableContext runnableContext) {
        ValidationStatus status = this.serverValidation(validateAgainstServer, validateSpace, runnableContext);
        if (validateAgainstServer && (status = this.checkSelfSignedError(status, runnableContext)) != null && status.getStatus().isOK()) {
            status = this.serverValidation(validateAgainstServer, validateSpace, runnableContext);
        }
        return status;
    }

    protected ValidationStatus checkSelfSignedError(ValidationStatus status, IRunnableContext context) {
        if (status == null) {
            return null;
        }
        final ValidationStatus[] validationStatus = new ValidationStatus[]{status};
        IStatus iStatus = validationStatus[0].getStatus();
        if (validationStatus[0].getEventType() == 1001 && iStatus.getException() instanceof SSLPeerUnverifiedException) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean storedSelfSign = ServerWizardValidator.this.cfServer.getSelfSignedCertificate();
                    if (!storedSelfSign) {
                        String message = NLS.bind((String)Messages.WARNING_SELF_SIGNED_PROMPT_USER, (Object)ServerWizardValidator.this.cfServer.getUrl());
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.TITLE_SELF_SIGNED_PROMPT_USER, (String)message)) {
                            storedSelfSign = true;
                            ServerWizardValidator.this.cfServer.setSelfSignedCertificate(storedSelfSign);
                        }
                    }
                    validationStatus[0] = storedSelfSign ? new ValidationStatus(Status.OK_STATUS, 1003) : new ValidationStatus(CloudFoundryPlugin.getErrorStatus((String)Messages.ERROR_UNABLE_CONNECT_SERVER_CREDENTIALS), 1001);
                }
            });
        }
        return validationStatus[0];
    }

    protected ValidationStatus serverValidation(boolean validateAgainstServer, boolean validateSpace, IRunnableContext runnableContext) {
        ValidationStatus validationStatus = this.validateLocally();
        String userName = this.cfServer.getUsername();
        String password = this.cfServer.getPassword();
        String url = this.cfServer.getUrl();
        boolean acceptSelfSigned = this.cfServer.getSelfSignedCertificate();
        IStatus eventStatus = null;
        if (validationStatus.getStatus().isOK()) {
            if (!this.cloudServerSpaceDelegate.matchesCurrentDescriptor(url, userName, password, acceptSelfSigned)) {
                this.cloudServerSpaceDelegate.clearDescriptor();
            }
            try {
                if (validateSpace) {
                    this.cloudServerSpaceDelegate.resolveDescriptor(url, userName, password, acceptSelfSigned, runnableContext, validateAgainstServer);
                } else if (validateAgainstServer) {
                    boolean displayURL = true;
                    CloudUiUtil.validateCredentials(userName, password, url, displayURL, acceptSelfSigned, runnableContext);
                }
            }
            catch (CoreException e) {
                int eventType = 1003;
                if (e.getCause() instanceof SSLPeerUnverifiedException) {
                    eventType = 1001;
                }
                eventStatus = e.getStatus();
                validationStatus = this.getValidationStatus(eventStatus, eventType);
            }
            catch (OperationCanceledException operationCanceledException) {
                eventStatus = null;
                validationStatus = this.getValidationStatus(Status.OK_STATUS, -1);
            }
        }
        return validationStatus;
    }

    protected ValidationStatus getValidationStatus(int statusType, String validationMessage, int eventType) {
        IStatus status = CloudFoundryPlugin.getStatus((String)validationMessage, (int)statusType);
        return this.getValidationStatus(status, eventType);
    }

    protected ValidationStatus getValidationStatus(IStatus status, int eventType) {
        return new ServerWizardValidationStatus(status, eventType);
    }

    protected abstract ValidationStatus validateLocally();

    private class ServerWizardValidationStatus
    extends ValidationStatus
    implements IAdaptable {
        public ServerWizardValidationStatus(IStatus status, int eventType) {
            super(status, eventType);
        }

        public Object getAdapter(Class clazz) {
            if (clazz.equals(PartChangeEvent.class)) {
                return new PartChangeEvent(null, this.getStatus(), ServerWizardValidator.this.validatorEventSource, this.getEventType());
            }
            return null;
        }
    }
}

