/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.StartingInfo;
import org.eclipse.cft.server.core.AbstractAppStateTracker;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.ApplicationOperation;
import org.eclipse.cft.server.core.internal.client.BehaviourRequest;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.cft.server.core.internal.client.StagingAwareRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;

public class RestartOperation
extends ApplicationOperation {
    public RestartOperation(CloudFoundryServerBehaviour behaviour, IModule[] modules, boolean clearConsole) {
        super(behaviour, modules, clearConsole);
    }

    @Override
    public String getOperationName() {
        return Messages.RestartOperation_STARTING_APP;
    }

    @Override
    protected void performDeployment(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        final Server server = (Server)this.getBehaviour().getServer();
        try {
            appModule.setStatus(null);
            final String deploymentName = appModule.getDeploymentInfo().getDeploymentName();
            if (deploymentName == null) {
                server.setModuleState(this.getModules(), 0);
                throw CloudErrorUtil.toCoreException("Unable to start application. Missing application deployment name in application deployment information.");
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            final CloudFoundryApplicationModule cloudModule = appModule = this.getBehaviour().updateModuleWithAllCloudInfo(appModule.getDeployedApplicationName(), (IProgressMonitor)subMonitor.newChild(20));
            ApplicationAction deploymentMode = this.getDeploymentConfiguration().getApplicationStartMode();
            if (deploymentMode != ApplicationAction.STOP) {
                String startLabel = String.valueOf(Messages.RestartOperation_STARTING_APP) + " - " + deploymentName;
                this.getBehaviour().printlnToConsole(cloudModule, startLabel);
                CloudFoundryPlugin.getCallback().startApplicationConsole(this.getBehaviour().getCloudFoundryServer(), cloudModule, 0, (IProgressMonitor)subMonitor.newChild(20));
                new BehaviourRequest<Void>(startLabel, this.getBehaviour()){

                    @Override
                    protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException, OperationCanceledException {
                        CloudFoundryPlugin.trace("Application " + deploymentName + " starting");
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)this.getRequestLabel()));
                        }
                        server.setModuleState(RestartOperation.this.getModules(), 1);
                        StartingInfo info = client.restartApplication(deploymentName);
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)this.getRequestLabel()));
                        }
                        if (info != null) {
                            cloudModule.setStartingInfo(info);
                            CloudFoundryPlugin.getCallback().applicationStarting(RestartOperation.this.getBehaviour().getCloudFoundryServer(), cloudModule);
                        }
                        return null;
                    }
                }.run((IProgressMonitor)subMonitor.newChild(20));
                new StagingAwareRequest<Void>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_WAITING_APP_START, (Object)deploymentName), this.getBehaviour()){

                    @Override
                    protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                        RestartOperation.this.getBehaviour().getApplicationInstanceRunningTracker(cloudModule).track((IProgressMonitor)progress);
                        CloudFoundryApplicationModule updatedModule = RestartOperation.this.getBehaviour().updateModuleWithAllCloudInfo(deploymentName, (IProgressMonitor)progress);
                        if (updatedModule == null || updatedModule.getApplication() == null) {
                            server.setModuleState(RestartOperation.this.getModules(), 4);
                            throw new OperationCanceledException(NLS.bind((String)Messages.RestartOperation_TERMINATING_APP_STOPPED_OR_NOT_EXISTS, (Object)deploymentName));
                        }
                        AbstractAppStateTracker curTracker = CloudFoundryPlugin.getAppStateTracker(RestartOperation.this.getBehaviour().getServer().getServerType().getId(), cloudModule);
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)this.getRequestLabel()));
                        }
                        if (curTracker != null) {
                            curTracker.setServer(RestartOperation.this.getBehaviour().getServer());
                            curTracker.startTracking(cloudModule, (IProgressMonitor)progress);
                        }
                        CloudFoundryPlugin.trace("Application " + deploymentName + " started");
                        CloudFoundryPlugin.getCallback().applicationStarted(RestartOperation.this.getBehaviour().getCloudFoundryServer(), cloudModule);
                        if (curTracker != null) {
                            boolean isAppStarting = true;
                            while (isAppStarting && !progress.isCanceled()) {
                                if (curTracker.getApplicationState(cloudModule) == 1) {
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    continue;
                                }
                                isAppStarting = false;
                            }
                            curTracker.stopTracking(cloudModule, (IProgressMonitor)progress);
                            server.setModuleState(RestartOperation.this.getModules(), 2);
                        } else {
                            server.setModuleState(RestartOperation.this.getModules(), cloudModule.getState());
                        }
                        return null;
                    }
                }.run((IProgressMonitor)subMonitor.newChild(40));
            } else {
                server.setModuleState(this.getModules(), 4);
                subMonitor.worked(80);
            }
        }
        catch (CoreException e) {
            appModule.setError(e);
            server.setModulePublishState(this.getModules(), 0);
            throw e;
        }
    }

    @Override
    protected DeploymentConfiguration getDefaultDeploymentConfiguration() {
        return new DeploymentConfiguration(ApplicationAction.RESTART);
    }
}

