/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.startcommand;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.ValueValidationUtil;
import org.eclipse.cft.server.standalone.core.internal.startcommand.StartCommand;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.JavaTypeUIAdapter;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.StartCommandPart;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.StartCommandPartFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class JavaStartCommandPart
extends StartCommandPart {
    private final StartCommandPartFactory startCommandPartFactory;
    private Text mainTypeText;
    private Text javaOptions;
    private Button browseButton;
    private JavaTypeUIAdapter typeAdapter;
    private StartCommand startCommand;
    private final IJavaProject javaProject;

    public JavaStartCommandPart(IJavaProject javaProject, StartCommandPartFactory startCommandPartFactory, StartCommand startCommand, Composite parent) {
        super(parent);
        this.startCommandPartFactory = startCommandPartFactory;
        this.startCommand = startCommand;
        this.javaProject = javaProject;
    }

    public Text getTypeText() {
        return this.mainTypeText != null && !this.mainTypeText.isDisposed() ? this.mainTypeText : null;
    }

    public Button getBrowseButton() {
        return this.browseButton != null && !this.browseButton.isDisposed() ? this.browseButton : null;
    }

    public Control createPart(Composite parent) {
        Composite javaStartArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(javaStartArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)javaStartArea);
        Composite mainTypeArea = this.startCommandPartFactory.create2ColumnComposite(javaStartArea);
        this.startCommandPartFactory.createdLabel(mainTypeArea, "Main Type:");
        Composite typeArea = this.startCommandPartFactory.create2ColumnComposite(mainTypeArea);
        this.mainTypeText = this.startCommandPartFactory.createdEditableText(typeArea);
        this.mainTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaStartCommandPart.this.updateStartCommand();
            }
        });
        this.browseButton = new Button(typeArea, 8);
        this.browseButton.setText("Browse...");
        GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)this.browseButton);
        if (this.javaProject != null) {
            this.typeAdapter = new JavaTypeUIAdapter(this, this.javaProject);
            this.typeAdapter.apply();
        }
        this.startCommandPartFactory.createdLabel(mainTypeArea, "Options:");
        this.javaOptions = this.startCommandPartFactory.createdEditableText(mainTypeArea);
        String defaultArgs = this.startCommand.getArgs();
        if (defaultArgs != null) {
            this.javaOptions.setText(defaultArgs);
        }
        this.javaOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaStartCommandPart.this.updateStartCommand();
            }
        });
        return javaStartArea;
    }

    @Override
    public void updateStartCommand() {
        String mainType = this.mainTypeText.getText();
        boolean isInvalid = ValueValidationUtil.isEmpty((String)mainType);
        String options = this.javaOptions.getText();
        StringBuilder startCommand = new StringBuilder("java");
        if (options != null) {
            startCommand.append(" ");
            startCommand.append(options);
        }
        if (mainType != null) {
            startCommand.append(" ");
            startCommand.append(mainType);
        }
        this.notifyStatusChange(startCommand.toString(), isInvalid ? CloudFoundryPlugin.getErrorStatus((String)"Invalid start command.") : Status.OK_STATUS);
    }
}

