/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractMenuContributionFactory
extends AbstractContributionFactory {
    public AbstractMenuContributionFactory(String location, String namespace) {
        super(location, namespace);
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        IMenuService menuService = (IMenuService)serviceLocator.getService(IMenuService.class);
        if (menuService == null) {
            CloudFoundryPlugin.logError((String)"Unable to retrieve Eclipse menu service. Cannot add Cloud Foundry context menus.");
            return;
        }
        List<IAction> debugActions = this.getActions(menuService);
        for (IAction action : debugActions) {
            additions.addContributionItem((IContributionItem)new ActionContributionItem(action), new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) {
                    return EvaluationResult.TRUE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                }
            });
        }
    }

    protected abstract List<IAction> getActions(IMenuService var1);
}

