/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.ui.internal.EventSource;
import org.eclipse.cft.server.ui.internal.IPartChangeListener;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class UIPart
extends EventSource<UIPart> {
    private List<IPartChangeListener> listeners = new ArrayList<IPartChangeListener>();

    public UIPart() {
        this.setSource(this);
    }

    public void addPartChangeListener(IPartChangeListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePartChangeListener(IPartChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void notifyChange(PartChangeEvent changeEvent) {
        for (IPartChangeListener listener : this.listeners) {
            listener.handleChange(changeEvent);
        }
    }

    protected void notifyStatusChange(IStatus status) {
        this.notifyStatusChange(null, status, -1);
    }

    protected void notifyStatusChange(IStatus status, int eventType) {
        this.notifyStatusChange(null, status, eventType);
    }

    protected void notifyStatusChange(Object data, IStatus status) {
        this.notifyStatusChange(data, status, -1);
    }

    protected void notifyStatusChange(Object data, IStatus status, int eventType) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        this.notifyChange(new PartChangeEvent(data, status, this, eventType));
    }

    public abstract Control createPart(Composite var1);
}

