/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.views;

import java.util.Map;
import org.eclipse.capra.ui.office.views.OfficeView;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SelectSheetDynamicMenu
extends ContributionItem {
    public void fill(Menu menu, int index) {
        Map<String, Boolean> isSheetEmptyMap = OfficeView.getOpenedView().getIsSheetEmptyMap();
        if (isSheetEmptyMap == null) {
            return;
        }
        for (Map.Entry<String, Boolean> sheet : isSheetEmptyMap.entrySet()) {
            final MenuItem menuItem = new MenuItem(menu, 16, index);
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OfficeView.getOpenedView().displaySheet(menuItem.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    OfficeView.getOpenedView().displaySheet(menuItem.getText());
                }
            });
            if (OfficeView.getOpenedView().getSelectedSheetName().contentEquals(sheet.getKey())) {
                menuItem.setSelection(true);
            }
            if (Boolean.FALSE.equals(sheet.getValue())) {
                menuItem.setText(sheet.getKey());
                continue;
            }
            menuItem.setText(String.valueOf(sheet.getKey()) + " (Empty)");
            menuItem.setEnabled(false);
        }
    }
}

