/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.model;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.NoSuchFileException;
import org.eclipse.capra.ui.office.exceptions.CapraOfficeObjectNotFound;

public class CapraOfficeObject {
    public static final String DOCX = "docx";
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String SHEET_PARAMETER = "sheet";
    public static final String ROW_PARAMETER = "row";
    private String data = "";
    private URI uri;

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUri(String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getInternalLocation() {
        return this.uri.getFragment();
    }

    public File getFile() throws NoSuchFileException {
        File officeFile = new File(this.uri);
        if (officeFile.exists()) {
            return officeFile;
        }
        throw new NoSuchFileException(this.uri.getPath());
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public void showOfficeObjectInNativeEnvironment() throws CapraOfficeObjectNotFound {
        try {
            Desktop.getDesktop().open(this.getFile());
        }
        catch (IOException e) {
            throw new CapraOfficeObjectNotFound(this.getInternalLocation(), e);
        }
    }

    public String toString() {
        return this.data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapraOfficeObject other = (CapraOfficeObject)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

