/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.tracemodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.capra.core.adapters.AbstractMetaModelAdapter;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.generic.tracemodel.GenericTraceModel;
import org.eclipse.capra.generic.tracemodel.RelatedTo;
import org.eclipse.capra.generic.tracemodel.TracemodelFactory;
import org.eclipse.capra.generic.tracemodel.TracemodelPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class GenericMetaModelAdapter
extends AbstractMetaModelAdapter
implements TraceMetaModelAdapter {
    private static final int DEFAULT_INITIAL_TRANSITIVITY_DEPTH = 1;

    public EObject createModel() {
        return TracemodelFactory.eINSTANCE.createGenericTraceModel();
    }

    public Collection<EClass> getAvailableTraceTypes(List<EObject> selection) {
        ArrayList<EClass> traceTypes = new ArrayList<EClass>();
        if (selection.size() > 1) {
            traceTypes.add(TracemodelPackage.eINSTANCE.getRelatedTo());
        }
        return traceTypes;
    }

    public EObject createTrace(EClass traceType, EObject traceModel, List<EObject> origins, List<EObject> targets) {
        final GenericTraceModel tm = (GenericTraceModel)traceModel;
        EObject trace = TracemodelFactory.eINSTANCE.create(traceType);
        final RelatedTo relatedToTrace = (RelatedTo)trace;
        relatedToTrace.setOrigin(origins.get(0));
        relatedToTrace.getTargets().addAll(targets);
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        StringBuilder name = new StringBuilder();
        name.append(((IArtifactHandler)artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)origins.get(0))).orElseThrow()).withCastedHandler(artifactHelper.unwrapWrapper((Object)origins.get(0)), (h, e) -> h.getDisplayName(e)).orElseGet(origins.get(0)::toString));
        for (EObject obj : targets) {
            name.append(" ").append(((IArtifactHandler)artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)obj)).orElseThrow()).withCastedHandler(artifactHelper.unwrapWrapper((Object)obj), (h, e) -> h.getDisplayName(e)).orElseGet(obj::toString));
        }
        relatedToTrace.setName(name.toString());
        TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain, "Add trace"){

            protected void doExecute() {
                tm.getTraces().add((Object)relatedToTrace);
            }
        };
        try {
            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
        }
        catch (RollbackException e2) {
            throw new IllegalStateException("Adding a trace link was rolled back.", e2);
        }
        catch (InterruptedException e3) {
            throw new IllegalStateException("Adding a trace link was interrupted.", e3);
        }
        return relatedToTrace;
    }

    public boolean isThereATraceBetween(EObject firstElement, EObject secondElement, EObject traceModel) {
        if (traceModel == null || firstElement == null || secondElement == null) {
            return false;
        }
        GenericTraceModel root = (GenericTraceModel)traceModel;
        ArrayList<RelatedTo> relevantLinks = new ArrayList<RelatedTo>();
        EList<RelatedTo> allTraces = root.getTraces();
        for (RelatedTo trace : allTraces) {
            if (firstElement.equals(secondElement) || !EMFHelper.hasSameIdentifier((EObject)firstElement, (EObject)trace.getOrigin()) || !EMFHelper.isElementInList(trace.getTargets(), (EObject)secondElement)) continue;
            relevantLinks.add(trace);
        }
        return !relevantLinks.isEmpty();
    }

    public List<Connection> getConnectedElements(EObject element, EObject tracemodel) {
        return this.getConnectedElements(element, tracemodel, new ArrayList<String>());
    }

    public List<Connection> getConnectedElements(EObject element, EObject tracemodel, List<String> selectedRelationshipTypes) {
        GenericTraceModel root = (GenericTraceModel)tracemodel;
        ArrayList<Connection> connections = new ArrayList<Connection>();
        EList<RelatedTo> traces = root.getTraces();
        if (selectedRelationshipTypes.isEmpty() || selectedRelationshipTypes.contains(TracemodelPackage.eINSTANCE.getRelatedTo().getName())) {
            if (element instanceof RelatedTo) {
                RelatedTo trace = (RelatedTo)element;
                connections.add(new Connection(Arrays.asList(element), trace.getTargets(), (EObject)trace));
            } else {
                for (RelatedTo trace : traces) {
                    if (!EcoreUtil.equals((EObject)element, (EObject)trace.getOrigin())) continue;
                    connections.add(new Connection(Arrays.asList(element), trace.getTargets(), (EObject)trace));
                }
            }
        }
        return connections;
    }

    private List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, List<Object> accumulator, int currentDepth, int maximumDepth) {
        List<Connection> directElements = this.getConnectedElements(element, traceModel);
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        int currDepth = currentDepth + 1;
        for (Connection connection : directElements) {
            if (accumulator.contains(connection.getTlink())) continue;
            allElements.add(connection);
            accumulator.add(connection.getTlink());
            for (EObject e : connection.getTargets()) {
                if (maximumDepth != 0 && currDepth > maximumDepth) continue;
                allElements.addAll(this.getTransitivelyConnectedElements(e, traceModel, accumulator, currDepth, maximumDepth));
            }
        }
        return allElements;
    }

    public List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, int maximumDepth) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        return this.getTransitivelyConnectedElements(element, traceModel, accumulator, 1, maximumDepth);
    }

    public List<Connection> getAllTraceLinks(EObject traceModel) {
        GenericTraceModel model = (GenericTraceModel)traceModel;
        ArrayList<Connection> allLinks = new ArrayList<Connection>();
        for (RelatedTo trace : model.getTraces()) {
            allLinks.add(new Connection(Arrays.asList(trace.getOrigin()), trace.getTargets(), (EObject)trace));
        }
        return allLinks;
    }

    public void deleteTrace(List<Connection> toDelete, EObject traceModel) {
        final ArrayList<RelatedTo> toRemove = new ArrayList<RelatedTo>();
        if (traceModel instanceof GenericTraceModel) {
            final GenericTraceModel tModel = (GenericTraceModel)traceModel;
            for (Connection c : toDelete) {
                for (RelatedTo trace : tModel.getTraces()) {
                    if (!EcoreUtil.equals((EObject)trace, (EObject)c.getTlink())) continue;
                    toRemove.add(trace);
                }
            }
            TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain, "Remove traces"){

                protected void doExecute() {
                    for (Object trace : toRemove) {
                        tModel.getTraces().remove(trace);
                    }
                }
            };
            try {
                ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
            }
            catch (RollbackException e) {
                throw new IllegalStateException("Removing trace links was rolled back.", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Removing trace links was interrupted.", e);
            }
            TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
            persistenceAdapter.saveTracesAndArtifacts((EObject)tModel, persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet()));
        }
    }

    public List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, List<String> traceLinkTypes, int maximumDepth) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        return this.getTransitivelyConnectedElements(element, traceModel, accumulator, traceLinkTypes, 1, maximumDepth);
    }

    private List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, List<Object> accumulator, List<String> traceLinkTypes, int currentDepth, int maximumDepth) {
        List<Connection> directElements = this.getConnectedElements(element, traceModel, traceLinkTypes);
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        int currDepth = currentDepth + 1;
        for (Connection connection : directElements) {
            if (accumulator.contains(connection.getTlink())) continue;
            allElements.add(connection);
            accumulator.add(connection.getTlink());
            for (EObject e : connection.getTargets()) {
                if (maximumDepth != 0 && currDepth > maximumDepth) continue;
                allElements.addAll(this.getTransitivelyConnectedElements(e, traceModel, accumulator, traceLinkTypes, currDepth, maximumDepth));
            }
        }
        return allElements;
    }
}

