/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.views;

import com.google.common.io.Files;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.SchemaTypeLoaderException;
import org.eclipse.capra.ui.office.Activator;
import org.eclipse.capra.ui.office.exceptions.CapraOfficeFileNotSupportedException;
import org.eclipse.capra.ui.office.exceptions.CapraOfficeObjectNotFound;
import org.eclipse.capra.ui.office.model.CapraExcelRow;
import org.eclipse.capra.ui.office.model.CapraGoogleSheetsRow;
import org.eclipse.capra.ui.office.model.CapraOfficeObject;
import org.eclipse.capra.ui.office.model.CapraWordRequirement;
import org.eclipse.capra.ui.office.utils.CapraOfficeUtils;
import org.eclipse.capra.ui.office.utils.OfficeSourceProvider;
import org.eclipse.capra.ui.office.utils.OfficeTransferType;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficeView
extends ViewPart {
    private static final Logger LOG = LoggerFactory.getLogger(OfficeView.class);
    public static final String ID = "org.eclipse.capra.ui.views.OfficeView";
    private static final String ERROR_TITLE = "Error";
    private static final String BUGZILLA_OFFICE_URL = "https://bugs.eclipse.org/bugs/show_bug.cgi?id=503313#add_comment";
    private TableViewer viewer;
    private List<CapraOfficeObject> selection = new ArrayList<CapraOfficeObject>();
    private Map<String, Boolean> isSheetEmptyMap;
    private String selectedSheetName;
    private File selectedFile;
    private String selectedFileId;
    private OfficeSourceProvider provider = (OfficeSourceProvider)((ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class)).getSourceProvider("org.eclipse.capra.ui.office.utils.capraOfficeObject");

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void createPartControl(final Composite parent) {
        this.viewer = new TableViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu();
        int ops = 3;
        Transfer[] transfersIn = new Transfer[]{FileTransfer.getInstance()};
        Transfer[] transfersOut = new Transfer[]{OfficeTransferType.getInstance()};
        this.viewer.addDropSupport(ops, transfersIn, (DropTargetListener)new SelectionDropAdapter(this.viewer));
        this.viewer.addDragSupport(ops, transfersOut, (DragSourceListener)new SelectionDragAdapter(this.viewer));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OfficeView.this.showObjectDetails(event, parent.getShell());
            }
        });
    }

    private void parseGenericFile(File file) throws CapraOfficeFileNotSupportedException {
        String fileExtension = Files.getFileExtension((String)file.getName());
        if (fileExtension.equals("xlsx") || fileExtension.equals("xls")) {
            this.parseExcelDocument(file, null, null);
        } else if (fileExtension.equals("docx")) {
            this.parseWordDocument(file);
        } else {
            throw new CapraOfficeFileNotSupportedException(fileExtension);
        }
    }

    public void parseExcelDocument(File officeFile, String googleDriveFileId, String sheetName) {
        Workbook workBook;
        try {
            workBook = CapraOfficeUtils.getExcelWorkbook(officeFile);
        }
        catch (OldExcelFormatException e) {
            this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
            return;
        }
        catch (IOException e) {
            this.showErrorMessage(ERROR_TITLE, "Could not open the Excel workbook.", null);
            LOG.warn("Could not open the Excel workbook", (Throwable)e);
            return;
        }
        Sheet sheet = CapraOfficeUtils.getSheet(workBook, sheetName);
        if (sheet == null) {
            String hyperlinkMessage = "It appears that the file doesn't contain any sheets. If that is not true, please report the issue to our <a href=\"https://bugs.eclipse.org/bugs/show_bug.cgi?id=503313#add_comment\"> Bugzilla project page </a> and we will do our best to resolve it.";
            this.showErrorMessage(ERROR_TITLE, hyperlinkMessage, BUGZILLA_OFFICE_URL);
            return;
        }
        Map<String, Boolean> isNewSheetEmptyMap = CapraOfficeUtils.getSheetsEmptinessInfo(workBook);
        if (!isNewSheetEmptyMap.values().contains(false)) {
            this.showErrorMessage(ERROR_TITLE, "There are no rows to display in any of the sheets.", null);
            this.clearSelection();
            return;
        }
        this.clearSelection();
        this.selectedSheetName = sheet.getSheetName();
        this.selectedFile = officeFile;
        this.selectedFileId = googleDriveFileId;
        this.isSheetEmptyMap = isNewSheetEmptyMap;
        String idColumn = Activator.getDefault().getPreferenceStore().getString("org.eclipse.capra.ui.office.preferences.excelColumnValue");
        boolean isGoogleSheet = googleDriveFileId != null;
        int i = 0;
        while (i <= sheet.getLastRowNum()) {
            CapraExcelRow cRow;
            Row row = sheet.getRow(i);
            if (row != null && !(cRow = isGoogleSheet ? new CapraGoogleSheetsRow(officeFile, row, idColumn, googleDriveFileId) : new CapraExcelRow(officeFile, row, idColumn)).getData().isEmpty()) {
                this.selection.add(cRow);
            }
            ++i;
        }
        if (!this.selection.isEmpty()) {
            this.provider.setResource(this.selection.get(0));
        }
        this.viewer.refresh();
    }

    private void parseWordDocument(File officeFile) {
        List<XWPFParagraph> paragraphs;
        try {
            paragraphs = CapraOfficeUtils.getWordParagraphs(officeFile);
        }
        catch (IOException e) {
            LOG.debug("Could not read Word file.", (Throwable)e);
            this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
            return;
        }
        catch (SchemaTypeLoaderException e) {
            LOG.debug("Could not read Word file.", (Throwable)e);
            this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
            return;
        }
        if (paragraphs.isEmpty()) {
            return;
        }
        this.clearSelection();
        this.selectedFile = officeFile;
        String fieldName = Activator.getDefault().getPreferenceStore().getString("org.eclipse.capra.ui.office.preferences.wordFieldId");
        int i = 0;
        while (i < paragraphs.size()) {
            CapraWordRequirement cRequirement;
            XWPFParagraph paragraph = paragraphs.get(i);
            if (paragraph != null && !(cRequirement = new CapraWordRequirement(officeFile, paragraph, fieldName)).getData().isEmpty()) {
                this.selection.add(cRequirement);
            }
            ++i;
        }
        if (this.selection.isEmpty()) {
            this.showErrorMessage(ERROR_TITLE, "There are no fields with the specified field name in this document.", null);
            this.clearSelection();
            return;
        }
        this.provider.setResource(this.selection.get(0));
        this.viewer.refresh();
    }

    public void showObjectDetails(Object event, Shell parentShell) {
        CapraOfficeObject officeObject;
        if (event instanceof DoubleClickEvent) {
            IStructuredSelection eventSelection = (IStructuredSelection)((DoubleClickEvent)event).getSelection();
            officeObject = (CapraOfficeObject)eventSelection.getFirstElement();
        } else if (event instanceof ExecutionEvent) {
            try {
                IStructuredSelection eventSelection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)((ExecutionEvent)event));
                officeObject = (CapraOfficeObject)eventSelection.getFirstElement();
            }
            catch (ExecutionException e) {
                LOG.warn("Could not get office object.", (Throwable)e);
                return;
            }
        } else {
            return;
        }
        try {
            officeObject.showOfficeObjectInNativeEnvironment();
        }
        catch (CapraOfficeObjectNotFound e) {
            LOG.debug("Could not find office object.", (Throwable)e);
            this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
        }
    }

    public void clearSelection() {
        this.selection.clear();
        this.viewer.refresh();
        this.provider.setResource(null);
        this.selectedSheetName = null;
        this.selectedFile = null;
        this.selectedFileId = null;
        this.isSheetEmptyMap = null;
    }

    public void openFile() {
        File file;
        FileDialog fd = new FileDialog(this.viewer.getControl().getShell(), 32);
        String filePath = fd.open();
        if (filePath != null && !filePath.isEmpty() && (file = new File(filePath)) != null && file.exists()) {
            try {
                this.parseGenericFile(file);
            }
            catch (CapraOfficeFileNotSupportedException e) {
                LOG.debug("Capra does not support the file.", (Throwable)e);
                this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
            }
        }
    }

    public void displaySheet(String sheetName) {
        if (this.selection.isEmpty()) {
            return;
        }
        if (this.selection.get(0) instanceof CapraExcelRow) {
            this.parseExcelDocument(this.selectedFile, this.selectedFileId, sheetName);
        }
    }

    public Map<String, Boolean> getIsSheetEmptyMap() {
        if (this.isSheetEmptyMap == null && this.selection.size() > 0) {
            try {
                this.isSheetEmptyMap = CapraOfficeUtils.getSheetsEmptinessInfo(CapraOfficeUtils.getExcelWorkbook(((CapraExcelRow)this.selection.get(0)).getFile()));
            }
            catch (IOException | OldExcelFormatException e) {
                LOG.debug("Could not open Excel file.", e);
            }
        }
        return this.isSheetEmptyMap;
    }

    public String getSelectedSheetName() {
        return this.selectedSheetName;
    }

    public static OfficeView getOpenedView() {
        try {
            return (OfficeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (PartInitException e) {
            LOG.debug("Could not open office view.", (Throwable)e);
            return null;
        }
    }

    public void refreshView() {
        if (this.selection.isEmpty()) {
            return;
        }
        if (this.selection.get(0) instanceof CapraExcelRow) {
            this.parseExcelDocument(this.selectedFile, this.selectedFileId, this.selectedSheetName);
        } else if (this.selection.get(0) instanceof CapraWordRequirement) {
            this.parseWordDocument(this.selectedFile);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void showErrorMessage(String caption, String message, String url) {
        new HyperlinkDialog(new HyperlinkDialog.HyperlinkDialogParameter(this.viewer.getControl().getShell(), caption, null, 1, new String[]{"OK"}, 0), message, url).open();
    }

    static class HyperlinkDialog
    extends MessageDialog {
        private static final int PREFERRED_DIALOG_WIDTH = 300;
        private String hyperlinkMessage;
        private String url;

        public HyperlinkDialog(HyperlinkDialogParameter parameterObject, String hyperlinkMessage, String url) {
            super(parameterObject.parentShell, parameterObject.dialogTitle, parameterObject.dialogTitleImage, null, parameterObject.dialogImageType, parameterObject.dialogButtonLabels, parameterObject.defaultIndex);
            this.hyperlinkMessage = hyperlinkMessage;
            this.url = url;
        }

        protected Control createCustomArea(Composite parent) {
            Link link = new Link(parent, 0);
            link.setText(this.hyperlinkMessage);
            GridData gd = new GridData();
            gd.widthHint = 300;
            link.setLayoutData((Object)gd);
            if (this.url != null && !this.url.contentEquals("")) {
                link.setToolTipText(this.url);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            Desktop.getDesktop().browse(new URI(url));
                            this.okPressed();
                        }
                        catch (IOException e1) {
                            LOG.info("No default browser found.", (Object)e);
                        }
                        catch (URISyntaxException e1) {
                            LOG.info("Provided malformed URI.", (Object)e);
                        }
                    }
                });
            }
            return link;
        }

        public static class HyperlinkDialogParameter {
            public Shell parentShell;
            public String dialogTitle;
            public Image dialogTitleImage;
            public int dialogImageType;
            public String[] dialogButtonLabels;
            public int defaultIndex;

            public HyperlinkDialogParameter(Shell parentShell, String dialogTitle, Image dialogTitleImage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
                this.parentShell = parentShell;
                this.dialogTitle = dialogTitle;
                this.dialogTitleImage = dialogTitleImage;
                this.dialogImageType = dialogImageType;
                this.dialogButtonLabels = dialogButtonLabels;
                this.defaultIndex = defaultIndex;
            }
        }
    }

    private static class SelectionDragAdapter
    extends ViewerDragAdapter {
        private TableViewer viewer;

        public SelectionDragAdapter(TableViewer viewer) {
            super((Viewer)viewer);
            this.viewer = viewer;
        }

        public void dragSetData(DragSourceEvent event) {
            if (OfficeTransferType.getInstance().isSupportedType(event.dataType)) {
                TableItem[] items = this.viewer.getTable().getSelection();
                ArrayList<CapraOfficeObject> officeObjects = new ArrayList<CapraOfficeObject>();
                int i = 0;
                while (i < items.length) {
                    officeObjects.add((CapraOfficeObject)items[i].getData());
                    ++i;
                }
                event.data = officeObjects;
            }
        }
    }

    class SelectionDropAdapter
    extends ViewerDropAdapter {
        public SelectionDropAdapter(TableViewer viewer) {
            super((Viewer)viewer);
        }

        public boolean performDrop(Object data) {
            try {
                File file;
                if (data instanceof String[] && (file = new File(((String[])data)[0])) != null && file.exists()) {
                    OfficeView.this.parseGenericFile(file);
                }
            }
            catch (CapraOfficeFileNotSupportedException e) {
                LOG.debug("Capra does not support this file.", (Throwable)e);
                OfficeView.this.showErrorMessage(OfficeView.ERROR_TITLE, e.getMessage(), null);
                return false;
            }
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return true;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return OfficeView.this.selection.toArray();
        }
    }

    static class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            int minAllowed = Activator.getDefault().getPreferenceStore().getInt("org.eclipse.capra.ui.office.preferences.charCount");
            String text = obj.toString();
            int textLength = Math.min(text.length(), minAllowed);
            if (textLength == minAllowed) {
                text = String.valueOf(text.substring(0, textLength)) + "...";
            }
            return text;
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

