/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.priority;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.PriorityHandler;

public class DefaultPriorityHandler
implements PriorityHandler {
    public <T> IArtifactHandler<? extends T> getSelectedHandler(Collection<? extends IArtifactHandler<? extends T>> handlers, Object artifact) {
        return handlers.stream().filter(handler -> handler.canHandleArtifact(artifact)).max(new ArtifactHandlerPriorityComparator()).get();
    }

    private class ArtifactHandlerPriorityComparator
    implements Comparator<IArtifactHandler<?>> {
        private ArtifactHandlerPriorityComparator() {
        }

        @Override
        public int compare(IArtifactHandler<?> o1, IArtifactHandler<?> o2) {
            if (!o1.getHandledClass().isAssignableFrom(o2.getHandledClass()) && o2.getHandledClass().isAssignableFrom(o1.getHandledClass())) {
                return 1;
            }
            if (o1.getHandledClass().isAssignableFrom(o2.getHandledClass()) && !o2.getHandledClass().isAssignableFrom(o1.getHandledClass())) {
                return -1;
            }
            return 0;
        }
    }
}

