/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.xtext.selections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.capra.ui.selections.ISelectionSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;

public class XtextOutlineSelectionSupport
implements ISelectionSupport {
    public boolean supportsWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof ContentOutline) {
            ISelection selection = ((ContentOutline)workbenchPart).getSelection();
            return !this.extractSelectedEObjectNodes(selection, workbenchPart).isEmpty();
        }
        return false;
    }

    private List<EObjectNode> extractSelectedEObjectNodes(ISelection selection, IWorkbenchPart workbenchPart) {
        ArrayList<EObjectNode> selectedElements = new ArrayList<EObjectNode>();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedEleme : ((IStructuredSelection)selection).toList()) {
                if (!(selectedEleme instanceof EObjectNode)) continue;
                selectedElements.add((EObjectNode)selectedEleme);
            }
        }
        return selectedElements;
    }

    public List<Object> extractSelectedElements(ISelection selection, IWorkbenchPart workbenchPart) {
        ArrayList<Object> selectedElements = new ArrayList<Object>();
        List<EObjectNode> selectedEObjectNodes = this.extractSelectedEObjectNodes(selection, workbenchPart);
        ResourceSet resSet = this.getResourceSet(workbenchPart);
        for (EObjectNode selectedEleme : selectedEObjectNodes) {
            URI objectUri = selectedEleme.getEObjectURI();
            selectedElements.add(resSet.getEObject(objectUri, true));
        }
        return selectedElements;
    }

    public ResourceSet getResourceSet(IWorkbenchPart workbenchPart) {
        return new ResourceSetImpl();
    }
}

