/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import org.eclipse.egf.common.ui.helper.EditorHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.ui.contributor.EditorMenuContributor;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public abstract class OpenEObjectMenuContributor
extends EditorMenuContributor {
    protected abstract OpenAction getOpenAction();

    protected abstract String getText();

    public void menuAboutToShow(IMenuManager menuManager) {
        IStructuredSelection innerSelection = (IStructuredSelection)this._selection;
        if (innerSelection.size() == 1 && this.getOpenAction().getEObject() != null) {
            this.getOpenAction().setText(this.getText());
            this.getOpenAction().setEnabled(this.getOpenAction().isEnabled());
            menuManager.insertBefore("open", (IAction)this.getOpenAction());
        }
    }

    protected abstract class OpenAction
    extends Action {
        public OpenAction(String id) {
            this.setId(id);
        }

        public boolean isEnabled() {
            EObject eObject = this.getEObject();
            if (eObject == null) {
                return false;
            }
            if (eObject instanceof InternalEObject) {
                return !((InternalEObject)eObject).eIsProxy();
            }
            return false;
        }

        public boolean isAlreadyOpenedEditor() {
            return EditorHelper.isAlreadyOpenedEditor((URI)this.getURI());
        }

        protected abstract EObject getEObject();

        protected URI getURI() {
            EObject eObject = this.getEObject();
            if (eObject == null) {
                return null;
            }
            return EcoreUtil.getURI((EObject)eObject);
        }

        protected URIConverter getURIConverter() {
            EObject eObject = this.getEObject();
            if (eObject == null) {
                return null;
            }
            if (eObject.eResource() != null && eObject.eResource().getResourceSet() != null && eObject.eResource().getResourceSet().getURIConverter() != null) {
                return eObject.eResource().getResourceSet().getURIConverter();
            }
            return null;
        }

        protected URI normalize(URI uri) {
            if (uri == null || this.getURIConverter() == null) {
                return uri;
            }
            return this.getURIConverter().normalize(uri);
        }

        public void run() {
            try {
                IEditorPart part;
                URI uri = this.getURI();
                if (uri != null && (part = EditorHelper.openEditor((URI)this.normalize(uri))) != null && part instanceof IEditingDomainProvider) {
                    EditorHelper.setSelectionToViewer((IEditorPart)part, (URI)uri);
                }
            }
            catch (PartInitException pie) {
                ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)pie);
            }
        }
    }
}

