/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.util.Map;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

public abstract class PatternEngine {
    private final Pattern pattern;
    private final String bundleId;

    public PatternEngine(Pattern pattern) throws PatternException {
        if (pattern == null) {
            throw new PatternException(EGFPatternMessages.engine_error1);
        }
        if (pattern.eResource() == null) {
            throw new PatternException(NLS.bind((String)EGFCoreMessages.EObject_no_Resource, (Object)EcoreUtil.getURI((EObject)pattern)));
        }
        IPlatformFcore fcore = null;
        if (pattern.eResource() instanceof IPlatformFcoreProvider) {
            fcore = ((IPlatformFcoreProvider)pattern.eResource()).getIPlatformFcore();
        }
        if (fcore == null) {
            throw new PatternException(NLS.bind((String)EGFCoreMessages.Fcore_not_found, (Object)EcoreUtil.getURI((EObject)pattern).trimFragment()));
        }
        if (fcore.getPlatformBundle().getBundleId() == null) {
            throw new PatternException(EGFPatternMessages.classloader_error4);
        }
        this.pattern = pattern;
        this.bundleId = fcore.getPlatformBundle().getBundleId();
    }

    protected Pattern getPattern() {
        return this.pattern;
    }

    protected String getBundleId() {
        return this.bundleId;
    }

    public abstract boolean checkCondition(PatternContext var1, Map<PatternParameter, Object> var2) throws PatternException;

    public abstract void executeWithInjection(PatternContext var1, Map<PatternParameter, Object> var2) throws PatternException;

    public abstract void execute(PatternContext var1) throws PatternException;

    public abstract void translate() throws PatternException;

    public abstract String getUnderlyingClassname() throws PatternException;
}

