/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class DiagramSessionHelper {
    private static URI airdUri;
    private static Session session;

    private DiagramSessionHelper() {
    }

    public static Session initSession() {
        if (!(session != null && session.isOpen() || airdUri == null)) {
            session = DiagramSessionHelper.findCorrespondingActiveSession(airdUri);
        }
        return session;
    }

    public static Session initSessionFromAirdURI(URI airdURI) {
        if (session == null) {
            session = DiagramSessionHelper.findCorrespondingActiveSession(airdURI);
        }
        return session;
    }

    public static Session findCorrespondingActiveSession(URI uri) {
        return SessionManager.INSTANCE.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Session getCurrentSession() {
        return session;
    }

    public static void setAirdUri(URI airdUri) {
        DiagramSessionHelper.airdUri = airdUri;
    }

    public static URI getAirdUri() {
        return airdUri;
    }

    public static Collection<DRepresentation> getSessionDRepresentation() {
        if (session != null) {
            return DialectManager.INSTANCE.getAllRepresentations(session);
        }
        return Collections.emptyList();
    }

    public static DDiagram getDDiagram(DRepresentationDescriptor descriptor) {
        if (session != null) {
            Collection<DRepresentation> representations = DiagramSessionHelper.getSessionDRepresentation();
            return DiagramSessionHelper.findCorrespondingDiagram(descriptor, representations);
        }
        return null;
    }

    public static DDiagram findCorrespondingDiagram(DRepresentationDescriptor descriptor, Collection<DRepresentation> representations) {
        for (DRepresentation dRepresentation : representations) {
            DDiagram diagram;
            if (!(dRepresentation instanceof DDiagram) || (diagram = (DDiagram)dRepresentation).getUid() == null || !diagram.getUid().equals(descriptor.getRepPath().getResourceURI().fragment())) continue;
            return diagram;
        }
        return null;
    }

    public static String getID(EObject eObject) {
        Resource sessionResource;
        String id = "";
        if (eObject instanceof DSemanticDiagram) {
            return ((DSemanticDiagram)eObject).getUid();
        }
        if (session != null && (sessionResource = session.getSessionResource()) instanceof XMLResource && (id = ((XMLResource)sessionResource).getID(eObject)) == null && EcoreUtil.getURI((EObject)eObject) != null) {
            id = EcoreUtil.getURI((EObject)eObject).fragment();
        }
        return id != null ? id : "";
    }

    public static void cleanSession() {
        session = null;
    }
}

