/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fcore.provider.FcoreResourceItemProviderAdapterFactory;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class FcoreModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(EGFModelEditorPlugin.INSTANCE.getString("_UI_FcoreEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = EGFModelEditorPlugin.INSTANCE.getString("_UI_FcoreEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected FcoreModelWizardNewFileCreationPage newFileCreationPage;
    protected FcoreModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;
    protected Map<String, EClass> roots = new HashMap<String, EClass>();
    protected FcoreResourceItemProviderAdapterFactory factory;

    public void init(IWorkbench innerWorkbench, IStructuredSelection innerSelection) {
        this.workbench = innerWorkbench;
        this.selection = innerSelection;
        this.setWindowTitle(EGFModelEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EGFModelEditorPlugin.INSTANCE.getImage("full/wizban/NewFcore")));
        this.setNeedsProgressMonitor(true);
        this.factory = new FcoreResourceItemProviderAdapterFactory();
        for (EClass eClass : this.factory.getRoots()) {
            this.roots.put(eClass.getName(), eClass);
        }
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            this.initialObjectNames.addAll(this.roots.keySet());
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = this.roots.get(this.initialObjectCreationPage.getInitialObjectName());
        EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        eObject.eSet((EStructuralFeature)FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME, (Object)this.getModelFile().getFullPath().removeFileExtension().lastSegment().toString());
        return eObject;
    }

    public boolean performFinish() {
        final IFile modelFile = this.getModelFile();
        final Throwable[] throwable = new Throwable[1];
        final EObject rootObject = this.createInitialModel();
        ConvertProjectOperation convertOperation = new ConvertProjectOperation(modelFile.getProject(), !(rootObject instanceof FactoryComponent), false);
        convertOperation.setInitialDependencies(new String[]{"org.eclipse.egf.model.ftask"});
        convertOperation.setInitialSourceFolders(new String[]{"src"});
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)convertOperation);
        }
        catch (Throwable t) {
            throwable[0] = t;
        }
        if (throwable[0] == null) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    SubMonitor.convert((IProgressMonitor)monitor, (String)EGFModelEditorPlugin.INSTANCE.getString("_UI_Wizard_createActivity"), (int)200);
                    TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
                    try {
                        URI uri = URIHelper.getPlatformPluginURI((IPath)modelFile.getFullPath());
                        Resource previousResource = editingDomain.getResourceSet().getResource(uri, false);
                        if (previousResource != null && previousResource.getContents().size() == 0 && !previousResource.getErrors().isEmpty()) {
                            previousResource.unload();
                            previousResource.getResourceSet().getResources().remove((Object)previousResource);
                        }
                        final Resource resource = editingDomain.getResourceSet().createResource(uri);
                        if (rootObject != null) {
                            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                                protected void doExecute() {
                                    resource.getContents().add((Object)rootObject);
                                }
                            });
                        }
                        editingDomain.runExclusive(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    resource.save(Collections.EMPTY_MAP);
                                }
                                catch (Throwable t) {
                                    throwable[0] = t;
                                }
                            }
                        });
                    }
                    catch (InterruptedException ie) {
                        throwable[0] = ie;
                    }
                }
            };
            try {
                this.getContainer().run(false, true, (IRunnableWithProgress)operation);
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
        }
        if (throwable[0] == null) {
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
        }
        if (throwable[0] != null && !(throwable[0] instanceof InterruptedException)) {
            ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getBundle().getSymbolicName(), (Throwable)throwable[0]);
            return false;
        }
        return true;
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new FcoreModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(EGFModelEditorPlugin.INSTANCE.getString("_UI_FcoreModelWizard_label"));
        this.newFileCreationPage.setDescription(EGFModelEditorPlugin.INSTANCE.getString("_UI_FcoreModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(EGFModelEditorPlugin.INSTANCE.getString("_UI_FcoreEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = EGFModelEditorPlugin.INSTANCE.getString("_UI_FcoreEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new FcoreModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(EGFModelEditorPlugin.INSTANCE.getString("_UI_FcoreModelWizard_label"));
        this.initialObjectCreationPage.setDescription(EGFModelEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class FcoreModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected ModifyListener validator;

        public FcoreModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FcoreModelWizardInitialObjectCreationPage.this.setPageComplete(FcoreModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(EGFModelEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            for (String objectName : FcoreModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(objectName));
            }
            this.initialObjectField.select(0);
            this.initialObjectField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                } else {
                    this.initialObjectField.setFocus();
                }
            }
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : FcoreModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        protected String getLabel(String typeName) {
            try {
                return FcoreModelWizard.this.factory.getResourceLocator().getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                EGFModelEditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }
    }

    public static class FcoreModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public FcoreModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(EGFModelEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

