/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.helpers.ctx.services.CapabilityExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractFunctionAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.docgen.util.CapellaServices;

public class CapellaCapabilityHelper {
    public static CapellaCapabilityHelper INSTANCE = new CapellaCapabilityHelper();

    private CapellaCapabilityHelper() {
    }

    public Collection<String> getExploitingMissions(String projectName, String outputFolder, Capability capability) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Mission m : CapabilityExt.getPurposeMissions((Capability)capability)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)m, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)m));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public Collection<String> getInvolvedActors(String projectName, String outputFolder, Capability capability) {
        ArrayList<String> ret = new ArrayList<String>();
        for (SystemComponent currentSystemComponent : CapabilityExt.getInvolvedSystemComponents((Capability)capability)) {
            if (!currentSystemComponent.isActor()) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentSystemComponent, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentSystemComponent));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public Collection<String> getExtendedCapabilities(String projectName, String outputFolder, Capability capability) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractCapability currentCapability : capability.getExtendedAbstractCapabilities()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentCapability, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentCapability));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public Collection<String> getIncludedCapabilities(String projectName, String outputFolder, Capability capability) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractCapability currentCapability : capability.getIncludedAbstractCapabilities()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentCapability, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentCapability));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public Collection<String> getParentCapabilities(String projectName, String outputFolder, Capability capability) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractCapability currentCapability : capability.getSuper()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentCapability, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentCapability));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public Collection<String> getInvolvedFunctions(String projectName, String outputFolder, AbstractCapability capability) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractFunctionAbstractCapabilityInvolvement currentCapabilityInvolvement : capability.getOwnedAbstractFunctionAbstractCapabilityInvolvements()) {
            InvolvedElement involvedElement = currentCapabilityInvolvement.getInvolved();
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)involvedElement, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)involvedElement));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public Collection<String> getAvailableModeAndState(String projectName, String outputFolder, Capability capability) {
        ArrayList<String> ret = new ArrayList<String>();
        for (State currentStateMode : capability.getAvailableInStates()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentStateMode, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentStateMode));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public Collection<String> getInvolvedComponent(String projectName, String outputFolder, CapabilityRealization capability) {
        ArrayList<String> ret = new ArrayList<String>();
        for (CapabilityRealizationInvolvedElement involvedElement : capability.getInvolvedComponents()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)involvedElement, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)involvedElement));
            ret.add(buffer.toString());
        }
        return ret;
    }
}

