/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenDiagramPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeStatus;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.SiriusHelper;

public class CapellaHelper {
    private static final String AIRD = ".aird";
    private static final String MELODYMODELLER = ".melodymodeller";

    public static Collection<DRepresentation> getDiagramForObject(CapellaElement element) {
        Collection<Object> representations = new ArrayList<DRepresentation>();
        if (!DocgenDiagramPreferencesHelper.getExportDiagram()) {
            return representations;
        }
        Session currentSession = DiagramSessionHelper.getCurrentSession();
        ScopeReferencesStrategy referencesStrategy = GenerationGlobalScope.getInstance().getReferencesStrategy();
        if (referencesStrategy.equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            EObject originalModelElement = GenerationGlobalScope.getInstance().getOriginalModelElement((EObject)element);
            representations = DialectManager.INSTANCE.getRepresentations(originalModelElement, currentSession);
        } else {
            representations = DialectManager.INSTANCE.getRepresentations((EObject)element, currentSession);
        }
        return representations.stream().filter(rep -> rep instanceof DSemanticDiagram).filter(rep -> CapellaHelper.exportRefToDiagram(rep, ((DSemanticDiagram)rep).getTarget())).collect(Collectors.toList());
    }

    public static Resource getAIRDResource(CapellaElement element) {
        URI uri = URI.createURI((String)element.eResource().getURI().toString().replace(MELODYMODELLER, AIRD));
        TransactionalEditingDomain domain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain();
        if (domain != null) {
            return domain.getResourceSet().getResource(uri, true);
        }
        return null;
    }

    public static Set<DSemanticDiagram> getDiagramContainingObject(CapellaElement element) {
        HashSet<DSemanticDiagram> diagrams = new HashSet<DSemanticDiagram>();
        if (GenerationGlobalScope.getInstance().getReferencesStrategy().equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            element = (CapellaElement)GenerationGlobalScope.getInstance().getOriginalModelElement((EObject)element);
        }
        CapellaHelper.getAllDiagramsForObject((EObject)element).stream().filter(rep -> rep instanceof DSemanticDiagram).filter(rep -> CapellaHelper.exportRefToDiagram(rep, ((DSemanticDiagram)rep).getTarget())).forEach(diag -> {
            boolean bl = diagrams.add((DSemanticDiagram)diag);
        });
        return diagrams;
    }

    private static Collection<DRepresentation> getAllDiagramsForObject(EObject element) {
        ArrayList<DRepresentation> result = new ArrayList<DRepresentation>();
        if (DocgenDiagramPreferencesHelper.getExportDiagram()) {
            EList<EObject> refElements = CapellaHelper.resolveReferencedElements(element);
            for (EObject refElement : refElements) {
                SiriusHelper.getDiagramForObject((EObject)refElement, (boolean)false).stream().forEach(rep -> {
                    if (!result.contains(rep)) {
                        result.add((DRepresentation)rep);
                    }
                });
            }
        }
        return result;
    }

    private static EList<EObject> resolveReferencedElements(EObject element) {
        BasicEList objects = new BasicEList();
        objects.add((Object)element);
        if (element instanceof AbstractType) {
            EList ates = ((AbstractType)element).getAbstractTypedElements();
            objects.addAll((Collection)ates);
            for (EObject ate : ates) {
                if (!(element instanceof AbstractInstance)) continue;
                objects.addAll((Collection)((AbstractInstance)ate).getRepresentingInstanceRoles());
            }
        }
        if (element instanceof AbstractInstance) {
            objects.addAll((Collection)((AbstractInstance)element).getRepresentingInstanceRoles());
        }
        return objects;
    }

    public static Collection<DDiagram> getAllInterestedRepresentationsFor(EObject semanticElement) {
        LinkedHashSet descriptors = new LinkedHashSet();
        Collection inverseReferences = new EObjectQuery(semanticElement).getInverseReferences(DescriptionPackage.Literals.DANNOTATION__REFERENCES);
        inverseReferences.forEach(eObject -> {
            DAnnotation annotation = (DAnnotation)eObject;
            if ("https://www.polarsys.org/capella/dannotation/eoi".equals(annotation.getSource())) {
                descriptors.add(annotation.eContainer());
            }
        });
        return descriptors.parallelStream().map(eObject -> (DRepresentationDescriptor)eObject).map(desc -> DiagramSessionHelper.getDDiagram((DRepresentationDescriptor)desc)).collect(Collectors.toList());
    }

    public static Collection<DRepresentation> getAllDiagramsIn(BlockArchitecture archi) {
        ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
        for (DRepresentation rep : DiagramSessionHelper.getSessionDRepresentation()) {
            BlockArchitecture originalContainer = archi;
            if (GenerationGlobalScope.getInstance().getScopeStatus().equals((Object)ScopeStatus.LIMITED)) {
                originalContainer = GenerationGlobalScope.getInstance().getOriginalModelElement((EObject)archi);
            }
            if (!originalContainer.equals(CapellaHelper.getBlockArchitectureContainer(rep))) continue;
            representations.add(rep);
        }
        return representations;
    }

    public static boolean hostDiagrams(BlockArchitecture archi) {
        for (DRepresentation rep : DiagramSessionHelper.getSessionDRepresentation()) {
            BlockArchitecture originalContainer = archi;
            if (GenerationGlobalScope.getInstance().getScopeStatus().equals((Object)ScopeStatus.LIMITED)) {
                originalContainer = GenerationGlobalScope.getInstance().getOriginalModelElement((EObject)archi);
            }
            if (!originalContainer.equals(CapellaHelper.getBlockArchitectureContainer(rep))) continue;
            return true;
        }
        return false;
    }

    private static EObject getBlockArchitectureContainer(DRepresentation representation) {
        EObject parent = null;
        if (representation instanceof DSemanticDiagram) {
            parent = ((DSemanticDiagram)representation).getTarget().eContainer();
        }
        while (!(parent instanceof BlockArchitecture) && parent != null) {
            parent = parent.eContainer();
        }
        return parent;
    }

    public static boolean exportRefToDiagram(DRepresentation rep, EObject target) {
        return GenerationGlobalScope.getInstance().inScope((EObject)rep, false) || GenerationGlobalScope.getInstance().getReferencesStrategy().equals((Object)ScopeReferencesStrategy.EXPORT) && GenerationGlobalScope.getInstance().inScope(target, false);
    }
}

