/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.requirement.Requirement;
import org.polarsys.capella.core.data.requirement.RequirementsPkg;
import org.polarsys.capella.docgen.diagram.CapellaHelper;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.SortedTreeNode;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;

public class TreeServices {
    public static final String REQUIREMENT_TREE_ID = "requirementTreeView";
    public static final String DIAGRAMS_TREE_ID = "diagramsTreeView";
    private static final Comparator<DefaultMutableTreeNode> requirementsComparator = new Comparator<DefaultMutableTreeNode>(){

        @Override
        public int compare(DefaultMutableTreeNode arg0, DefaultMutableTreeNode arg1) {
            Object obj0 = arg0.getUserObject();
            Object obj1 = arg1.getUserObject();
            if (obj0 instanceof RequirementsPkg && obj1 instanceof Requirement) {
                return 1;
            }
            if (obj0 instanceof Requirement && obj1 instanceof RequirementsPkg) {
                return -1;
            }
            if (obj0 instanceof NamedElement && obj1 instanceof NamedElement) {
                return ((NamedElement)obj0).getName().compareTo(((NamedElement)obj1).getName());
            }
            return 0;
        }
    };
    private static final Comparator<DefaultMutableTreeNode> diagramsComparator = new Comparator<DefaultMutableTreeNode>(){

        @Override
        public int compare(DefaultMutableTreeNode arg0, DefaultMutableTreeNode arg1) {
            String str0;
            Object obj0 = arg0.getUserObject();
            Object obj1 = arg1.getUserObject();
            String string = obj0 instanceof DRepresentation ? ((DRepresentation)obj0).getName() : (obj0 instanceof Viewpoint ? ((Viewpoint)obj0).getName() : (str0 = obj0 instanceof RepresentationDescription ? ((RepresentationDescription)obj0).getName() : ""));
            String str1 = obj1 instanceof DRepresentation ? ((DRepresentation)obj1).getName() : (obj1 instanceof Viewpoint ? ((Viewpoint)obj1).getName() : (obj1 instanceof RepresentationDescription ? ((RepresentationDescription)obj1).getName() : ""));
            return str0.compareTo(str1);
        }
    };

    public static String getRequirementsTree(EList<Requirement> appliedReq, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        DefaultMutableTreeNode tree = TreeServices.buildRequirementsTree(appliedReq);
        sb.append("<ul id=\"").append(REQUIREMENT_TREE_ID).append("\" class=\"treeview\">");
        sb.append(TreeServices.printRequirementsTree(tree, projectName, outputFolder));
        sb.append("</ul>");
        return sb.toString();
    }

    private static DefaultMutableTreeNode buildRequirementsTree(EList<Requirement> appliedReq) {
        SortedTreeNode<DefaultMutableTreeNode> tree = new SortedTreeNode<DefaultMutableTreeNode>(requirementsComparator);
        HashMap<RequirementsPkg, SortedTreeNode<DefaultMutableTreeNode>> reqPkgToTreeNodeMap = new HashMap<RequirementsPkg, SortedTreeNode<DefaultMutableTreeNode>>();
        for (Requirement req : appliedReq) {
            SortedTreeNode<DefaultMutableTreeNode> currentNode = new SortedTreeNode<DefaultMutableTreeNode>((Object)req, requirementsComparator);
            EObject parent = req.eContainer();
            boolean hasFoundParent = false;
            while (parent instanceof RequirementsPkg) {
                SortedTreeNode<DefaultMutableTreeNode> pkgNode = (SortedTreeNode<DefaultMutableTreeNode>)reqPkgToTreeNodeMap.get(parent);
                if (pkgNode == null) {
                    pkgNode = new SortedTreeNode<DefaultMutableTreeNode>((Object)parent, requirementsComparator);
                    reqPkgToTreeNodeMap.put((RequirementsPkg)parent, pkgNode);
                } else {
                    hasFoundParent = true;
                }
                pkgNode.add(currentNode);
                currentNode = pkgNode;
                parent = parent.eContainer();
                if (hasFoundParent) break;
            }
            if (hasFoundParent) continue;
            tree.add(currentNode);
        }
        return tree;
    }

    private static String printRequirementsTree(DefaultMutableTreeNode tree, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        Enumeration<TreeNode> childs = tree.children();
        if (childs instanceof Enumeration) {
            while (childs.hasMoreElements()) {
                DefaultMutableTreeNode node;
                TreeNode element = childs.nextElement();
                if (!(element instanceof DefaultMutableTreeNode) || !((node = (DefaultMutableTreeNode)element).getUserObject() instanceof EObject)) continue;
                EObject obj = (EObject)node.getUserObject();
                sb.append("<li>");
                sb.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, obj));
                if (obj instanceof RequirementsPkg) {
                    sb.append("<ul>");
                    sb.append(TreeServices.printRequirementsTree(node, projectName, outputFolder));
                    sb.append("</ul>");
                }
                sb.append("</li>");
            }
        }
        return sb.toString();
    }

    public static String getDiagramsTree(BlockArchitecture archi, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        DefaultMutableTreeNode tree = TreeServices.buildDiagramsTree(archi);
        sb.append("<ul id=\"").append(DIAGRAMS_TREE_ID).append("\" class=\"treeview\">");
        sb.append(TreeServices.printDiagramsTree(tree, projectName, outputFolder));
        sb.append("</ul>");
        return sb.toString();
    }

    private static DefaultMutableTreeNode buildDiagramsTree(BlockArchitecture archi) {
        SortedTreeNode<DefaultMutableTreeNode> tree = new SortedTreeNode<DefaultMutableTreeNode>(diagramsComparator);
        HashMap<DiagramDescription, SortedTreeNode<DefaultMutableTreeNode>> repDescToTreeNodeMap = new HashMap<DiagramDescription, SortedTreeNode<DefaultMutableTreeNode>>();
        HashMap<Viewpoint, SortedTreeNode<DefaultMutableTreeNode>> vpToTreeNodeMap = new HashMap<Viewpoint, SortedTreeNode<DefaultMutableTreeNode>>();
        for (DRepresentation rep : CapellaHelper.getAllDiagramsIn(archi)) {
            SortedTreeNode<DefaultMutableTreeNode> vpNode;
            EObject target;
            DiagramDescription description = null;
            if (rep instanceof DSemanticDiagram) {
                target = ((DSemanticDiagram)rep).getTarget();
                if (!GenerationGlobalScope.getInstance().inScope(target, false)) continue;
                description = ((DSemanticDiagram)rep).getDescription();
            } else {
                if (!(rep instanceof DTable)) break;
                target = ((DTable)rep).getTarget();
                if (!GenerationGlobalScope.getInstance().inScope(target, false)) continue;
                description = ((DTable)rep).getDescription();
            }
            Viewpoint vp = (Viewpoint)description.eContainer();
            SortedTreeNode<DefaultMutableTreeNode> descNode = (SortedTreeNode<DefaultMutableTreeNode>)repDescToTreeNodeMap.get(description);
            if (descNode == null) {
                descNode = new SortedTreeNode<DefaultMutableTreeNode>((Object)description, diagramsComparator);
                repDescToTreeNodeMap.put(description, descNode);
            }
            if ((vpNode = (SortedTreeNode<DefaultMutableTreeNode>)vpToTreeNodeMap.get(vp)) == null) {
                vpNode = new SortedTreeNode<DefaultMutableTreeNode>((Object)vp, diagramsComparator);
                vpToTreeNodeMap.put(vp, vpNode);
            }
            SortedTreeNode<DefaultMutableTreeNode> repNode = new SortedTreeNode<DefaultMutableTreeNode>((Object)rep, diagramsComparator);
            if (!tree.isNodeChild(vpNode)) {
                tree.add(vpNode);
            }
            if (!vpNode.isNodeChild(descNode)) {
                vpNode.add(descNode);
            }
            descNode.add(repNode);
        }
        return tree;
    }

    private static String printDiagramsTree(DefaultMutableTreeNode tree, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        Enumeration<TreeNode> childs = tree.children();
        if (childs instanceof Enumeration) {
            while (childs.hasMoreElements()) {
                DefaultMutableTreeNode node;
                sb.append("<li>");
                TreeNode element = childs.nextElement();
                if (element instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)element).getUserObject() instanceof EObject) {
                    EObject obj = (EObject)node.getUserObject();
                    if (obj instanceof Viewpoint) {
                        Viewpoint vp = (Viewpoint)obj;
                        sb.append(CapellaServices.getImageLinkFromElement((EObject)vp, projectName, outputFolder));
                        sb.append(CapellaServices.getHyperlinkFromElement((EObject)vp, vp.getName()));
                        sb.append("<ul>");
                        sb.append(TreeServices.printDiagramsTree(node, projectName, outputFolder));
                        sb.append("</ul>");
                    } else if (obj instanceof RepresentationDescription) {
                        RepresentationDescription description = (RepresentationDescription)obj;
                        sb.append(CapellaServices.getImageLinkFromElement((EObject)description, projectName, outputFolder));
                        sb.append(description.getName());
                        sb.append("<ul>");
                        sb.append(TreeServices.printDiagramsTree(node, projectName, outputFolder));
                        sb.append("</ul>");
                    } else if (obj instanceof DRepresentation) {
                        DRepresentation rep = (DRepresentation)obj;
                        sb.append(CapellaServices.getImageLinkFromElement((EObject)rep, projectName, outputFolder));
                        sb.append(CapellaServices.getHyperlinkFromElement((EObject)rep, rep.getName()));
                    }
                }
                sb.append("</li>");
            }
        }
        return sb.toString();
    }
}

