/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class RemoveChoreographyParticipantFeature
extends DefaultRemoveFeature {
    public RemoveChoreographyParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canRemove(IRemoveContext context) {
        return ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)context.getPictogramElement());
    }

    public void execute(IContext context) {
        IRemoveContext dc = (IRemoveContext)context;
        PictogramElement pe = dc.getPictogramElement();
        ContainerShape choreographyActivityShape = null;
        if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)pe)) {
            Shape labelShape = FeatureSupport.getLabelShape((PictogramElement)pe);
            if (labelShape != null) {
                Graphiti.getPeService().deletePictogramElement((PictogramElement)labelShape);
            }
            Participant participant = (Participant)this.getBusinessObjectForPictogramElement(pe);
            choreographyActivityShape = (ContainerShape)pe.eContainer();
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)choreographyActivityShape);
            if (bo instanceof ChoreographyActivity) {
                ChoreographyActivity choreographyActivity = (ChoreographyActivity)bo;
                choreographyActivity.getParticipantRefs().remove(participant);
                if (choreographyActivity.getInitiatingParticipantRef() == participant) {
                    Participant initiatingParticipant = null;
                    if (choreographyActivity.getParticipantRefs().size() > 0) {
                        initiatingParticipant = (Participant)choreographyActivity.getParticipantRefs().get(0);
                    }
                    choreographyActivity.setInitiatingParticipantRef(initiatingParticipant);
                }
            }
            if (bo instanceof ChoreographyTask) {
                ChoreographyTask choreographyTask = (ChoreographyTask)bo;
                ArrayList messageFlows = new ArrayList();
                messageFlows.addAll(choreographyTask.getMessageFlowRef());
                for (MessageFlow mf : messageFlows) {
                    if (mf.getSourceRef() != participant) continue;
                    choreographyTask.getMessageFlowRef().remove(mf);
                }
            }
            super.execute(context);
            ChoreographyUtil.updateParticipantBands((IFeatureProvider)this.getFeatureProvider(), (PictogramElement)choreographyActivityShape);
        }
    }
}

