/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.RuntimeTypeProxy;
import org.eclipse.wst.server.discovery.ServerProxy;

public class ServerTypeProxy
implements IServerType {
    private String serverId;
    private String serverName;
    private String serverDescription;
    private IRuntimeType runtimeType;
    private String extension;
    private String uri;
    private String proxyServerId;

    public ServerTypeProxy(String id, String name, String description, String hostName, IRuntimeType runtimeType) {
        this.serverId = id;
        this.serverName = name;
        this.serverDescription = description;
        this.runtimeType = runtimeType;
    }

    public ServerTypeProxy(ServerProxy serverProxy) {
        this.serverId = serverProxy.getId();
        this.serverName = serverProxy.getName();
        this.serverDescription = serverProxy.getDescription();
        this.runtimeType = new RuntimeTypeProxy(serverProxy.getRuntimeType());
        this.extension = serverProxy.getExtension();
        this.uri = serverProxy.getURI();
        this.proxyServerId = serverProxy.getProxyServerId();
    }

    @Override
    public String getId() {
        return this.serverId;
    }

    @Override
    public String getName() {
        return this.serverName;
    }

    @Override
    public String getDescription() {
        return this.serverDescription;
    }

    @Override
    public IRuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    @Override
    public boolean hasRuntime() {
        return false;
    }

    @Override
    public boolean requiresRuntime() {
        return false;
    }

    public void dispose() {
        this.runtimeType = null;
    }

    public String getExtension() {
        return this.extension;
    }

    public String toString() {
        return "ServerType[" + this.getId() + "]";
    }

    @Override
    public boolean supportsLaunchMode(String launchMode) {
        return false;
    }

    @Override
    public boolean hasServerConfiguration() {
        return false;
    }

    @Override
    public boolean supportsRemoteHosts() {
        return true;
    }

    @Override
    public IServerWorkingCopy createServer(String id, IFile file, IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public IServerWorkingCopy createServer(String id, IFile file, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public String getURI() {
        return this.uri;
    }

    public String getProxyServerId() {
        return this.proxyServerId;
    }
}

