/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.odp;

import java.awt.Color;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.odp.OdpRender;
import org.eclipse.birt.report.engine.layout.emitter.util.BackgroundImageLayout;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;
import org.eclipse.birt.report.engine.odf.style.HyperlinkInfo;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.writer.AbstractOdfWriter;

public class OdpWriter
extends AbstractOdfWriter {
    protected static Logger logger = Logger.getLogger(OdpRender.class.getName());
    protected int currentPageNum = 0;
    protected float pageWidth;
    protected float pageHeight;

    public OdpWriter(OutputStream out) throws Exception {
        this(out, "UTF-8");
    }

    public OdpWriter(OutputStream out, String encoding) throws Exception {
        this.writer = new XMLWriter();
        this.writer.setIndent(false);
        this.writer.open(out, encoding);
    }

    public void start() {
        this.writer.openTag("office:body");
        this.writer.openTag("office:presentation");
    }

    public void end() {
        this.writer.closeTag("office:presentation");
        this.writer.closeTag("office:body");
        try {
            this.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    public void endPage() {
        this.writer.closeTag("draw:page");
    }

    public void newPage(float pageWidth, float pageHeight, Color backgroundColor, String mpName) {
        ++this.currentPageNum;
        if (pageWidth > this.pageWidth) {
            this.pageWidth = pageWidth;
        }
        if (pageHeight > this.pageHeight) {
            this.pageHeight = pageHeight;
        }
        this.writer.openTag("draw:page");
        this.writer.attribute("draw:name", "Slide" + this.currentPageNum);
        if (mpName != null) {
            this.writer.attribute("draw:master-page-name", mpName);
        }
    }

    public void drawText(String text, float textX, float textY, float width, float height, StyleEntry frameStyle, StyleEntry style, HyperlinkInfo link) {
        this.writer.openTag("draw:frame");
        if (frameStyle != null) {
            this.writer.attribute("draw:style-name", frameStyle.getName());
        }
        this.writer.attribute("draw:layer", "layout");
        this.writer.attribute("svg:width", String.valueOf(width /= 72.0f) + "in");
        this.writer.attribute("svg:height", String.valueOf(height /= 72.0f) + "in");
        this.writer.attribute("svg:x", String.valueOf(textX /= 72.0f) + "in");
        this.writer.attribute("svg:y", String.valueOf(textY /= 72.0f) + "in");
        this.writer.openTag("draw:text-box");
        this.writer.openTag("text:p");
        this.writer.openTag("text:span");
        if (style != null) {
            this.writer.attribute("text:style-name", style.getName());
        }
        this.openHyperlink(link);
        this.writeString(text);
        this.closeHyperlink(link);
        this.writer.closeTag("text:span");
        this.writer.closeTag("text:p");
        this.writer.closeTag("draw:text-box");
        this.writer.closeTag("draw:frame");
    }

    public void drawImage(String imageId, byte[] imageData, String imageUrl, String extension, float imageX, float imageY, float height, float width, String helpText, HyperlinkInfo link) {
        this.openHyperlink(link, "draw");
        double posX = imageX / 72.0f;
        double posY = imageY / 72.0f;
        double imageWidth = width / 72.0f;
        double imageHeight = height / 72.0f;
        this.drawImage(imageUrl, imageData, posX, posY, imageHeight, imageWidth, null, helpText, "layout", this.getImageID());
        this.closeHyperlink(link, "draw");
    }

    public void drawLine(double startX, double startY, double endX, double endY, StyleEntry styleEntry) {
        this.drawRawLine(startX, startY, endX, endY, styleEntry);
    }

    private void drawRawLine(double startX, double startY, double endX, double endY, StyleEntry lineStyle) {
        boolean needflip = false;
        if (endX > startX && endY < startY || endX < startX && endY > startY) {
            needflip = true;
        }
        this.writer.openTag("draw:line");
        this.writer.attribute("draw:layer", "layout");
        if (lineStyle != null) {
            this.writer.attribute("draw:style-name", lineStyle.getName());
        }
        startX /= 72.0;
        startY /= 72.0;
        endX /= 72.0;
        endY /= 72.0;
        if (needflip) {
            this.writer.attribute("svg:x1", String.valueOf(startX) + "in");
            this.writer.attribute("svg:y1", String.valueOf(endY) + "in");
            this.writer.attribute("svg:x2", String.valueOf(endX) + "in");
            this.writer.attribute("svg:y2", String.valueOf(startY) + "in");
        } else {
            this.writer.attribute("svg:x1", String.valueOf(startX) + "in");
            this.writer.attribute("svg:y1", String.valueOf(startY) + "in");
            this.writer.attribute("svg:x2", String.valueOf(endX) + "in");
            this.writer.attribute("svg:y2", String.valueOf(endY) + "in");
        }
        this.writer.closeTag("draw:line");
    }

    public void drawBackgroundColor(double x, double y, double width, double height, StyleEntry rectStyle) {
        this.writer.openTag("draw:rect");
        if (rectStyle != null) {
            this.writer.attribute("draw:style-name", rectStyle.getName());
        }
        this.writer.attribute("draw:layer", "layout");
        this.writer.attribute("svg:width", String.valueOf(width /= 72.0) + "in");
        this.writer.attribute("svg:height", String.valueOf(height /= 72.0) + "in");
        this.writer.attribute("svg:x", String.valueOf(x /= 72.0) + "in");
        this.writer.attribute("svg:y", String.valueOf(y /= 72.0) + "in");
        this.writer.closeTag("draw:rect");
    }

    public void drawBackgroundImage(String imageURI, float x, float y, float width, float height, float iWidth, float iHeight, float positionX, float positionY, int repeat) {
        if (imageURI == null || imageURI.length() == 0) {
            return;
        }
        float imageWidth = iWidth;
        float imageHeight = iHeight;
        Position areaPosition = new Position(x, y);
        Position areaSize = new Position(width, height);
        Position imagePosition = new Position(x + positionX, y + positionY);
        Position imageSize = new Position(imageWidth, imageHeight);
        BackgroundImageLayout layout = new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
        List positions = layout.getImagePositions(repeat);
        for (Position position : positions) {
            this.drawImage(imageURI, null, imageURI, null, position.getX(), position.getY(), imageHeight, imageWidth, null, null);
        }
    }
}

