/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataResultSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SummaryDataSetPopulator
implements IDataSetPopulator {
    private ResultIterator docIt;
    private IResultClass resultClass;

    public SummaryDataSetPopulator(IQueryDefinition queryDefn, ResultIterator docIt, IExprDataResultSet exprResultSet) throws DataException {
        this.docIt = docIt;
        this.resultClass = exprResultSet.getResultClass();
    }

    @Override
    public IResultObject next() throws DataException {
        if (!this.docIt.next()) {
            return null;
        }
        Object[] field = new Object[this.resultClass.getFieldCount()];
        int i = 0;
        while (i < field.length) {
            String columnName = this.resultClass.getFieldName(i + 1);
            try {
                field[i] = "_$$_dte_inner_row_id_$$_".equals(columnName) ? Integer.valueOf(this.docIt.getRowId()) : this.docIt.getValue(columnName);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            ++i;
        }
        return new ResultObject(this.resultClass, field);
    }

    public IResultClass getResultClass() {
        return this.resultClass;
    }
}

