/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.core.security.ObjectSecurity;
import org.eclipse.birt.data.engine.executor.cache.IntegerHolder;
import org.eclipse.birt.data.engine.executor.cache.Md5Util;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;

public class CacheUtil {
    private static final int MAX_DIR_CREATION_ATTEMPT = 1000;
    private static final String PATH_SEP = File.separator;
    private static final String TEST_MEM_BUFFER_SIZE = "birt.data.engine.test.memcachesize";
    private static final int MAGIC_NUMBER = 2000000000;
    private static final String TIME_DATA = "time.data";
    private static final String PS_ = "PS_";
    private static IntegerHolder cacheCounter1 = new IntegerHolder(0);
    private static IntegerHolder cacheCounter2 = new IntegerHolder(0);

    private CacheUtil() {
    }

    public static long computeMemoryBufferSize(Map appContext) {
        if (appContext == null) {
            return 0L;
        }
        if (appContext.get(TEST_MEM_BUFFER_SIZE) != null) {
            return CacheUtil.populateMemBufferSize(appContext.get(TEST_MEM_BUFFER_SIZE));
        }
        return CacheUtil.populateMemBufferSize(appContext.get(DataEngine.MEMORY_BUFFER_SIZE)) * 1024L * 1024L;
    }

    public static boolean enableSP3CubeQueryChange(Map appContext) {
        if (appContext == null) {
            return false;
        }
        Object propValue = appContext.get(DataEngine.MEMORY_BUFFER_SIZE);
        String targetBufferSize = propValue == null ? "0" : propValue.toString();
        long memoryCacheSize = 0L;
        if (targetBufferSize != null) {
            memoryCacheSize = Long.parseLong(targetBufferSize);
        }
        return memoryCacheSize > 2000000000L;
    }

    public static int getMaxRows(Map appContext) {
        if (appContext == null) {
            return -1;
        }
        Object maxRows = appContext.get(DataEngine.MAX_DATA_OBJECT_ROWS);
        if (maxRows != null) {
            return Integer.parseInt(maxRows.toString());
        }
        return -1;
    }

    private static long populateMemBufferSize(Object propValue) {
        String targetBufferSize = propValue == null ? "0" : propValue.toString();
        long memoryCacheSize = 0L;
        if (targetBufferSize != null) {
            memoryCacheSize = Long.parseLong(targetBufferSize);
        }
        return memoryCacheSize > 2000000000L ? memoryCacheSize - 2000000000L : memoryCacheSize;
    }

    public static String createTempRootDir(String tempDir) throws DataException {
        File tempDtEDir = new File(tempDir, "BirtDataTemp" + System.currentTimeMillis() + cacheCounter1.intValue());
        cacheCounter1.add(1);
        int x = 0;
        while (FileSecurity.fileExist(tempDtEDir)) {
            tempDtEDir = new File(tempDir, "BirtDataTemp" + System.currentTimeMillis() + cacheCounter1.intValue() + "_" + ++x);
        }
        FileSecurity.fileMakeDirs(tempDtEDir);
        String rootDirStr = CacheUtil.getCanonicalPath(tempDtEDir);
        return rootDirStr;
    }

    public static String createSessionTempDir(String tempRootDir) throws DataException {
        String prefix = "session_";
        String sessionTempDir = String.valueOf(tempRootDir) + File.separator + "session_" + System.currentTimeMillis() + cacheCounter2.intValue();
        cacheCounter2.add(1);
        File sessionFile = new File(sessionTempDir);
        int i = 0;
        String tempDir = sessionTempDir;
        while (FileSecurity.fileExist(sessionFile)) {
            sessionTempDir = String.valueOf(tempDir) + "_" + ++i;
            sessionFile = new File(sessionTempDir);
            if (i <= 1000) continue;
            throw new DataException("data.engine.failToCreateTempDir", CacheUtil.diagnosticMkdirs(sessionFile));
        }
        if (!FileSecurity.fileMakeDirs(sessionFile)) {
            throw new DataException("data.engine.failToCreateTempDir", CacheUtil.diagnosticMkdirs(sessionFile));
        }
        return CacheUtil.getCanonicalPath(sessionFile);
    }

    private static String diagnosticMkdirs(File directory) throws DataException {
        File canonFile;
        String parent;
        do {
            canonFile = null;
            try {
                canonFile = FileSecurity.fileGetCanonicalFile(directory);
            }
            catch (IOException e) {
                return FileSecurity.fileGetAbsolutePath(directory);
            }
            parent = canonFile.getParent();
            if (parent != null) continue;
            return FileSecurity.fileGetAbsolutePath(directory);
        } while (!FileSecurity.fileExist(directory = new File(parent)) && !FileSecurity.fileMakeDirs(directory));
        try {
            return FileSecurity.fileGetCanonicalPath(canonFile);
        }
        catch (IOException e) {
            return FileSecurity.fileGetAbsolutePath(directory);
        }
    }

    private static String getCanonicalPath(File file) throws DataException {
        try {
            return FileSecurity.fileGetCanonicalPath(file);
        }
        catch (IOException e) {
            return FileSecurity.fileGetAbsolutePath(file);
        }
    }

    public static String createIncrementalTempDir(DataEngineSession session, IIncreCacheDataSetDesign dataSetDesign) throws DataException {
        String prefix = PS_;
        File cacheDir = new File(String.valueOf(session.getTempDir()) + PATH_SEP + PS_ + PATH_SEP + Md5Util.getMD5(dataSetDesign.getConfigFileUrl().toString()) + PATH_SEP + dataSetDesign.getName());
        if (!FileSecurity.fileExist(cacheDir)) {
            FileSecurity.fileMakeDirs(cacheDir);
        }
        return CacheUtil.getCanonicalPath(cacheDir);
    }

    public static String getLastTime(String folder) throws DataException {
        File file;
        block5: {
            file = new File(String.valueOf(folder) + PATH_SEP + TIME_DATA);
            if (FileSecurity.fileExist(file)) break block5;
            return null;
        }
        try {
            FileInputStream fis = FileSecurity.createFileInputStream(file);
            ObjectInputStream ois = ObjectSecurity.createObjectInputStream(fis);
            String lastTime = (String)ObjectSecurity.readObject(ois);
            fis.close();
            ois.close();
            return lastTime;
        }
        catch (IOException e) {
            throw new DataException("data.engine.datasetcache.save.error", e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    public static void saveCurrentTime(String folder) throws DataException {
        try {
            FileOutputStream fos = FileSecurity.createFileOutputStream(new File(String.valueOf(folder) + PATH_SEP + TIME_DATA));
            ObjectOutputStream oos = ObjectSecurity.createObjectOutputStream(fos);
            Calendar calendar = Calendar.getInstance();
            StringBuilder buffer = new StringBuilder();
            buffer.append(CacheUtil.populate2DigitString(calendar.get(1)));
            buffer.append(CacheUtil.populate2DigitString(calendar.get(2) + 1));
            buffer.append(CacheUtil.populate2DigitString(calendar.get(5)));
            if (calendar.get(9) == 1) {
                buffer.append(CacheUtil.populate2DigitString(calendar.get(10) + 12));
            }
            buffer.append(CacheUtil.populate2DigitString(calendar.get(12)));
            buffer.append(CacheUtil.populate2DigitString(calendar.get(13)));
            oos.writeObject(buffer.toString());
            fos.close();
            oos.close();
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    private static String populate2DigitString(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return String.valueOf(value);
    }

    public static long getLastTimestamp(String folder) throws DataException {
        try {
            RandomAccessFile raf = FileSecurity.createRandomAccessFile(String.valueOf(folder) + PATH_SEP + "timestamp.data", "r");
            long timestamp = raf.readLong();
            raf.close();
            return timestamp;
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public static void saveCurrentTimestamp(String folder) throws DataException {
        try {
            RandomAccessFile raf = FileSecurity.createRandomAccessFile(String.valueOf(folder) + PATH_SEP + "timestamp.data", "rw");
            Calendar calendar = Calendar.getInstance();
            raf.writeLong(calendar.getTimeInMillis());
            raf.close();
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }
}

