/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb;

import java.io.File;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.sqlite.SQLiteConfig;

public class DBConnection<T extends DBConnection<T>>
implements AutoCloseable {
    private static final String TABLE_EXISTS_QUERY = "SELECT name FROM sqlite_master WHERE type = 'table' AND name = ?;";
    private final Connection connection;
    private final Map<String, PreparedStatement> prepStmts;
    private final Map<String, PreparedStatement> prepIdStmts;
    private final Collection<Statement> stmts;
    private final Set<PreparedStatement> currentBatches;
    private boolean isInBatchMode = false;
    private final File dbFile;
    private final AccessMode accessMode;

    public DBConnection(String dbFile) throws SQLException {
        this(dbFile, AccessMode.ReadOnly);
    }

    public DBConnection(String dbFileName, AccessMode accessMode) throws SQLException {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        this.dbFile = new File(dbFileName);
        this.accessMode = accessMode;
        if (accessMode == AccessMode.ReadOnly) {
            SQLiteConfig config = new SQLiteConfig();
            config.setReadOnly(true);
            String dbFileUrl = "jdbc:sqlite:" + this.dbFile.getAbsolutePath();
            this.connection = config.createConnection(dbFileUrl);
        } else {
            SQLiteConfig config = new SQLiteConfig();
            config.enforceForeignKeys(true);
            config.setJournalMode(SQLiteConfig.JournalMode.OFF);
            if (accessMode == AccessMode.ReadWriteInMemory) {
                config.setTempStore(SQLiteConfig.TempStore.MEMORY);
            } else {
                config.setSynchronous(SQLiteConfig.SynchronousMode.OFF);
            }
            String dbFileUrl = "jdbc:sqlite:" + (accessMode == AccessMode.ReadWriteInMemory ? ":memory:" : this.dbFile.getAbsolutePath());
            this.connection = config.createConnection(dbFileUrl);
            if (accessMode == AccessMode.ReadWriteInMemory && this.dbFile.exists()) {
                Throwable throwable = null;
                Object var6_9 = null;
                try (Statement fileRestoreStmt = this.connection.createStatement();){
                    String restoreDB = String.format("restore from '%s'", this.dbFile.getAbsolutePath());
                    fileRestoreStmt.executeUpdate(restoreDB);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        this.prepStmts = new LinkedHashMap<String, PreparedStatement>();
        this.prepIdStmts = new LinkedHashMap<String, PreparedStatement>();
        this.stmts = new LinkedHashSet<Statement>();
        this.currentBatches = new LinkedHashSet<PreparedStatement>();
    }

    public void flushAllStatements() throws SQLException {
        for (PreparedStatement ps : this.prepStmts.values()) {
            ps.close();
        }
        this.prepStmts.clear();
        this.prepIdStmts.clear();
    }

    @Override
    public void close() throws SQLException {
        this.flushAllStatements();
        if (this.accessMode == AccessMode.ReadWriteInMemory) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Statement fileBackupStmt = this.connection.createStatement();){
                String backupDB = String.format("backup to '%s'", this.dbFile.getAbsolutePath());
                fileBackupStmt.executeUpdate(backupDB);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.connection.close();
    }

    public void executeUpdate(String query) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement statement = this.connection.createStatement();){
            statement.setQueryTimeout(30);
            statement.executeUpdate(query);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void executeLargeUpdate(String query) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement statement = this.connection.createStatement();){
            statement.executeLargeUpdate(query);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void queryAndConsumeResult(String query, ThrowingConsumer<ResultSet, SQLException> consumer) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement tmpStatement = this.connection.createStatement(1003, 1007);){
            ResultSet resultSet = tmpStatement.executeQuery(query);
            consumer.accept(resultSet);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <R> Stream<R> queryAndMapToStream(PreparedStatement query, ThrowingFunction<ResultSet, R, SQLException> rowMapper) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet resultSet = query.executeQuery();){
            Stream.Builder<R> result = Stream.builder();
            while (resultSet.next()) {
                result.accept(rowMapper.apply(resultSet));
            }
            return result.build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public PreparedStatement getPreparedStatementFor(String query) throws SQLException {
        if (!this.prepStmts.containsKey(query)) {
            this.prepStmts.put(query, this.connection.prepareStatement(query));
        }
        return this.prepStmts.get(query);
    }

    protected PreparedStatement getPreparedStatementFor(String query, String idName) throws SQLException {
        if (!this.prepIdStmts.containsKey(query)) {
            if (idName != null && !idName.isEmpty()) {
                this.prepIdStmts.put(query, this.connection.prepareStatement(query, new String[]{idName}));
            } else {
                this.prepIdStmts.put(query, this.getPreparedStatementFor(query));
            }
        }
        return this.prepIdStmts.get(query);
    }

    public PreparedStatement getPrepareQueryFor(String query) throws SQLException {
        if (!this.prepStmts.containsKey(query)) {
            this.prepStmts.put(query, this.connection.prepareStatement(query, 1003, 1007));
        }
        return this.prepStmts.get(query);
    }

    public Statement createStatement() throws SQLException {
        Statement stmt = this.connection.createStatement();
        this.stmts.add(stmt);
        return stmt;
    }

    public void executeBatchStatements(Statement ... statements) throws SQLException {
        this.executeBatchStatements(Arrays.asList(statements));
    }

    public void executeBatchStatements(Collection<? extends Statement> statements) throws SQLException {
        boolean oldAutoCommit = this.connection.getAutoCommit();
        if (oldAutoCommit) {
            this.connection.setAutoCommit(false);
        }
        try {
            for (Statement statement : statements) {
                statement.executeBatch();
            }
        }
        finally {
            this.connection.setAutoCommit(oldAutoCommit);
        }
    }

    public boolean tableExists(String tableName) throws SQLException {
        PreparedStatement prepStmt = this.getPrepareQueryFor(TABLE_EXISTS_QUERY);
        prepStmt.setString(1, tableName);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet resultSet = prepStmt.executeQuery();){
            return resultSet.next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void executeBatchUpdate(ThrowingConsumer<T, SQLException> batchConsumer) throws SQLException {
        this.isInBatchMode = true;
        DBConnection self = this;
        batchConsumer.accept(self);
        this.executeBatchStatements(this.currentBatches);
        this.currentBatches.clear();
        this.isInBatchMode = false;
    }

    public void setPreparedParameters(PreparedStatement stmt, List<?> parameters) throws SQLException {
        ParameterMetaData pmd = stmt.getParameterMetaData();
        if (pmd.getParameterCount() == parameters.size()) {
            int i = 0;
            while (i < parameters.size()) {
                stmt.setObject(i + 1, parameters.get(i));
                ++i;
            }
        }
    }

    protected long executePrepStmtAndGetGeneratedId(String prepStmt, List<?> parameters) throws SQLException {
        PreparedStatement stmt = this.getPreparedStatementFor(prepStmt, "id");
        this.setPreparedParameters(stmt, parameters);
        int affectedRows = stmt.executeUpdate();
        if (affectedRows == 0) {
            throw new SQLException("Statement: " + stmt + " failed. No rows affected.");
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (ResultSet rs = stmt.getGeneratedKeys();){
            if (rs.next()) {
                return rs.getLong(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return -1L;
    }

    protected void executeBatchablePrepStmt(String prepStmt, List<?> parameters) throws SQLException {
        PreparedStatement stmt = this.getPreparedStatementFor(prepStmt);
        this.setPreparedParameters(stmt, parameters);
        if (this.isInBatchMode) {
            stmt.addBatch();
            this.currentBatches.add(stmt);
        } else {
            stmt.executeUpdate();
        }
    }

    public static enum AccessMode {
        ReadOnly,
        ReadWrite,
        ReadWriteInMemory;

    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

